/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.features;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Produces;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.b2.binders.UploadFileBinder;
import org.jclouds.b2.domain.B2Object;
import org.jclouds.b2.domain.B2ObjectList;
import org.jclouds.b2.domain.DeleteFileResponse;
import org.jclouds.b2.domain.HideFileResponse;
import org.jclouds.b2.domain.UploadFileResponse;
import org.jclouds.b2.domain.UploadUrlResponse;
import org.jclouds.b2.filters.RequestAuthorization;
import org.jclouds.b2.filters.RequestAuthorizationDownload;
import org.jclouds.b2.functions.ParseB2ObjectFromResponse;
import org.jclouds.blobstore.attr.BlobScope;
import org.jclouds.blobstore.attr.BlobScopes;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@BlobScope(value=BlobScopes.CONTAINER)
public interface ObjectApi {
    @Named(value="b2_get_upload_url")
    @POST
    @Path(value="/b2api/v2/b2_get_upload_url")
    @RequestFilters(value={RequestAuthorization.class})
    @MapBinder(value=BindToJsonPayload.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public UploadUrlResponse getUploadUrl(@PayloadParam(value="bucketId") String var1);

    @Named(value="b2_upload_file")
    @POST
    @MapBinder(value=UploadFileBinder.class)
    @Consumes(value={"application/json"})
    public UploadFileResponse uploadFile(@PayloadParam(value="uploadUrl") UploadUrlResponse var1, @PayloadParam(value="fileName") String var2, @Nullable @PayloadParam(value="contentSha1") String var3, @PayloadParam(value="fileInfo") Map<String, String> var4, Payload var5);

    @Named(value="b2_delete_file_version")
    @POST
    @Path(value="/b2api/v2/b2_delete_file_version")
    @MapBinder(value=BindToJsonPayload.class)
    @RequestFilters(value={RequestAuthorization.class})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DeleteFileResponse deleteFileVersion(@PayloadParam(value="fileName") String var1, @PayloadParam(value="fileId") String var2);

    @Named(value="b2_get_file_info")
    @POST
    @Path(value="/b2api/v2/b2_get_file_info")
    @MapBinder(value=BindToJsonPayload.class)
    @RequestFilters(value={RequestAuthorization.class})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public B2Object getFileInfo(@PayloadParam(value="fileId") String var1);

    @Named(value="b2_download_file_by_id")
    @GET
    @Path(value="/b2api/v2/b2_download_file_by_id")
    @RequestFilters(value={RequestAuthorizationDownload.class})
    @ResponseParser(value=ParseB2ObjectFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public B2Object downloadFileById(@QueryParam(value="fileId") String var1);

    @Named(value="b2_download_file_by_id")
    @GET
    @Path(value="/b2api/v2/b2_download_file_by_id")
    @RequestFilters(value={RequestAuthorizationDownload.class})
    @ResponseParser(value=ParseB2ObjectFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public B2Object downloadFileById(@QueryParam(value="fileId") String var1, GetOptions var2);

    @Named(value="b2_download_file_by_name")
    @GET
    @Path(value="/file/{bucketName}/{fileName}")
    @RequestFilters(value={RequestAuthorizationDownload.class})
    @ResponseParser(value=ParseB2ObjectFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public B2Object downloadFileByName(@PathParam(value="bucketName") String var1, @PathParam(value="fileName") String var2);

    @Named(value="b2_download_file_by_name")
    @GET
    @Path(value="/file/{bucketName}/{fileName}")
    @RequestFilters(value={RequestAuthorizationDownload.class})
    @ResponseParser(value=ParseB2ObjectFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public B2Object downloadFileByName(@PathParam(value="bucketName") String var1, @PathParam(value="fileName") String var2, GetOptions var3);

    @Deprecated
    @Named(value="b2_list_file_names")
    @GET
    @Path(value="/b2api/v2/b2_list_file_names")
    @MapBinder(value=BindToJsonPayload.class)
    @RequestFilters(value={RequestAuthorization.class})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public B2ObjectList listFileNames(@PayloadParam(value="bucketId") String var1, @PayloadParam(value="startFileName") @Nullable String var2, @PayloadParam(value="maxFileCount") @Nullable Integer var3);

    @Named(value="b2_list_file_names")
    @GET
    @Path(value="/b2api/v2/b2_list_file_names")
    @MapBinder(value=BindToJsonPayload.class)
    @RequestFilters(value={RequestAuthorization.class})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public B2ObjectList listFileNames(@PayloadParam(value="bucketId") String var1, @PayloadParam(value="startFileName") @Nullable String var2, @PayloadParam(value="maxFileCount") @Nullable Integer var3, @PayloadParam(value="prefix") @Nullable String var4, @Nullable @PayloadParam(value="delimiter") String var5);

    @Deprecated
    @Named(value="b2_list_file_versions")
    @GET
    @Path(value="/b2api/v2/b2_list_file_versions")
    @MapBinder(value=BindToJsonPayload.class)
    @RequestFilters(value={RequestAuthorization.class})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public B2ObjectList listFileVersions(@PayloadParam(value="bucketId") String var1, @PayloadParam(value="startFileId") @Nullable String var2, @PayloadParam(value="startFileName") @Nullable String var3, @PayloadParam(value="maxFileCount") @Nullable Integer var4);

    @Named(value="b2_list_file_versions")
    @GET
    @Path(value="/b2api/v2/b2_list_file_versions")
    @MapBinder(value=BindToJsonPayload.class)
    @RequestFilters(value={RequestAuthorization.class})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public B2ObjectList listFileVersions(@PayloadParam(value="bucketId") String var1, @PayloadParam(value="startFileId") @Nullable String var2, @PayloadParam(value="startFileName") @Nullable String var3, @PayloadParam(value="maxFileCount") @Nullable Integer var4, @PayloadParam(value="prefix") @Nullable String var5, @PayloadParam(value="delimiter") @Nullable String var6);

    @Named(value="b2_hide_file")
    @POST
    @Path(value="/b2api/v2/b2_hide_file")
    @MapBinder(value=BindToJsonPayload.class)
    @RequestFilters(value={RequestAuthorization.class})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public HideFileResponse hideFile(@PayloadParam(value="bucketId") String var1, @PayloadParam(value="fileName") String var2);
}

