/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.FluentIterable;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.Hasher;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.Hashing;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteSource;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.logging.Logger;
import org.jclouds.util.Closeables2;

@Singleton
public final class LocalBlobStore
implements BlobStore {
    private static final String MULTIPART_PREFIX = ".mpus-";
    @Resource
    private Logger logger = Logger.NULL;
    private final BlobStoreContext context;
    private final BlobUtils blobUtils;
    private final Supplier<Set<? extends Location>> locations;
    private final ContentMetadataCodec contentMetadataCodec;
    private final Blob.Factory blobFactory;
    private final LocalStorageStrategy storageStrategy;

    @Inject
    LocalBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Memoized Supplier<Set<? extends Location>> locations, ContentMetadataCodec contentMetadataCodec, Blob.Factory blobFactory, LocalStorageStrategy storageStrategy) {
        this.context = Preconditions.checkNotNull(context, "context");
        this.blobUtils = Preconditions.checkNotNull(blobUtils, "blobUtils");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.blobFactory = blobFactory;
        this.contentMetadataCodec = contentMetadataCodec;
        this.storageStrategy = storageStrategy;
    }

    @Override
    public BlobStoreContext getContext() {
        return this.context;
    }

    @Override
    public BlobBuilder blobBuilder(String name) {
        return this.blobUtils.blobBuilder().name(name);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String containerName) {
        return this.list(containerName, ListContainerOptions.NONE);
    }

    @Override
    public long countBlobs(String containerName) {
        return this.countBlobs(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public long countBlobs(String containerName, ListContainerOptions options) {
        return this.blobUtils.countBlobs(containerName, options);
    }

    @Override
    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String containerName, ListContainerOptions options) {
        this.blobUtils.clearContainer(containerName, options);
    }

    @Override
    public void deleteDirectory(String containerName, String directory) {
        this.blobUtils.deleteDirectory(containerName, directory);
    }

    @Override
    public boolean directoryExists(String containerName, String directory) {
        return this.blobUtils.directoryExists(containerName, directory);
    }

    @Override
    public void createDirectory(String containerName, String directory) {
        if (!this.blobUtils.directoryExists(containerName, directory)) {
            this.blobUtils.createDirectory(containerName, directory);
        }
    }

    @Override
    public Blob getBlob(String containerName, String key) {
        return this.getBlob(containerName, key, GetOptions.NONE);
    }

    @Override
    public void deleteContainer(String containerName) {
        this.deleteAndVerifyContainerGone(containerName);
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return this.locations.get();
    }

    @Override
    public PageSet<? extends StorageMetadata> list(final String containerName, ListContainerOptions options) {
        if (options.getDir() != null && options.getPrefix() != null) {
            throw new IllegalArgumentException("Cannot set both prefix and directory");
        }
        if ((options.getDir() != null || options.isRecursive()) && options.getDelimiter() != null) {
            throw new IllegalArgumentException("Cannot set the delimiter if directory or recursive is set");
        }
        if (!this.storageStrategy.containerExists(containerName)) {
            throw this.cnfe(containerName);
        }
        Iterable<String> blobBelongingToContainer = null;
        try {
            blobBelongingToContainer = this.storageStrategy.getBlobKeysInsideContainer(containerName, options.getPrefix());
        }
        catch (IOException e) {
            this.logger.error(e, "An error occurred loading blobs contained into container %s", containerName);
            Throwables.propagate(e);
        }
        blobBelongingToContainer = Iterables.filter(blobBelongingToContainer, new Predicate<String>(){

            @Override
            public boolean apply(String key) {
                return LocalBlobStore.this.storageStrategy.blobExists(containerName, key);
            }
        });
        SortedSet<StorageMetadata> contents = Sets.newTreeSet(FluentIterable.from(blobBelongingToContainer).transform(new Function<String, StorageMetadata>(){

            @Override
            public StorageMetadata apply(String key) {
                Blob oldBlob = LocalBlobStore.this.loadBlob(containerName, key);
                if (oldBlob == null) {
                    return null;
                }
                Preconditions.checkState(oldBlob.getMetadata() != null, "blob " + containerName + "/" + key + " has no metadata");
                MutableBlobMetadata md = BlobStoreUtils.copy(oldBlob.getMetadata());
                md.setSize(oldBlob.getMetadata().getSize());
                return md;
            }
        }).filter(Predicates.notNull()));
        String marker = null;
        if (options != null) {
            int maxResults;
            if (options.getDir() != null && !options.getDir().isEmpty()) {
                contents = this.filterDirectory(contents, options);
            } else if (!Strings.isNullOrEmpty(options.getPrefix())) {
                contents = this.filterPrefix(contents, options);
            } else if (!options.isRecursive() || options.getDelimiter() != null) {
                String delimiter = options.getDelimiter() == null ? this.storageStrategy.getSeparator() : options.getDelimiter();
                contents = this.extractCommonPrefixes(contents, delimiter, null);
            }
            if (options.getMarker() != null) {
                final String finalMarker = options.getMarker();
                String delimiter = this.storageStrategy.getSeparator();
                Optional<StorageMetadata> lastMarkerMetadata = Iterables.tryFind(contents, new Predicate<StorageMetadata>(){

                    @Override
                    public boolean apply(StorageMetadata metadata) {
                        return metadata.getName().compareTo(finalMarker) > 0;
                    }
                });
                if (lastMarkerMetadata.isPresent()) {
                    contents = contents.tailSet(lastMarkerMetadata.get());
                } else {
                    contents.clear();
                }
            }
            int n = maxResults = options.getMaxResults() != null ? options.getMaxResults() : 1000;
            if (!contents.isEmpty()) {
                StorageMetadata lastElement = contents.last();
                contents = Sets.newTreeSet(Iterables.limit(contents, maxResults));
                if (maxResults != 0 && !contents.contains(lastElement)) {
                    lastElement = contents.last();
                    marker = lastElement.getName();
                }
            }
            if (!options.isDetailed()) {
                for (StorageMetadata md : contents) {
                    md.getUserMetadata().clear();
                }
            }
        }
        return new PageSetImpl<StorageMetadata>(contents, marker);
    }

    private SortedSet<StorageMetadata> filterDirectory(SortedSet<StorageMetadata> contents, ListContainerOptions options) {
        String prefix = options.getDir();
        final String dirPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
        contents = Sets.newTreeSet(Sets.filter(contents, new Predicate<StorageMetadata>(){

            @Override
            public boolean apply(StorageMetadata o) {
                return o != null && o.getName().replace(File.separatorChar, '/').startsWith(dirPrefix) && !o.getName().replace(File.separatorChar, '/').equals(dirPrefix);
            }
        }));
        if (!options.isRecursive()) {
            return this.extractCommonPrefixes(contents, this.storageStrategy.getSeparator(), dirPrefix);
        }
        return contents;
    }

    private SortedSet<StorageMetadata> filterPrefix(SortedSet<StorageMetadata> contents, final ListContainerOptions options) {
        contents = Sets.newTreeSet(Sets.filter(contents, new Predicate<StorageMetadata>(){

            @Override
            public boolean apply(StorageMetadata o) {
                return o != null && o.getName().replace(File.separatorChar, '/').startsWith(options.getPrefix());
            }
        }));
        if (options.getDelimiter() != null || !options.isRecursive()) {
            String delimiter = options.getDelimiter() == null ? this.storageStrategy.getSeparator() : options.getDelimiter();
            return this.extractCommonPrefixes(contents, delimiter, options.getPrefix());
        }
        return contents;
    }

    private SortedSet<StorageMetadata> extractCommonPrefixes(SortedSet<StorageMetadata> contents, String delimiter, String prefix) {
        if (Strings.isNullOrEmpty(delimiter)) {
            return contents;
        }
        TreeSet<String> commonPrefixes = Sets.newTreeSet(Iterables.transform(contents, new CommonPrefixes(prefix, delimiter)));
        commonPrefixes.remove("NO_PREFIX");
        contents = Sets.newTreeSet(Sets.filter(contents, new DelimiterFilter(prefix, delimiter)));
        for (String o : commonPrefixes) {
            MutableStorageMetadataImpl md = new MutableStorageMetadataImpl();
            md.setType(StorageType.RELATIVE_PATH);
            if (prefix != null) {
                o = prefix + o;
            }
            md.setName(o + delimiter);
            contents.add(md);
        }
        return contents;
    }

    private ContainerNotFoundException cnfe(String name) {
        return new ContainerNotFoundException(name, String.format("container %s not in %s", name, this.storageStrategy.getAllContainerNames()));
    }

    @Override
    public void removeBlob(String containerName, String key) {
        if (!this.storageStrategy.containerExists(containerName)) {
            throw this.cnfe(containerName);
        }
        this.storageStrategy.removeBlob(containerName, key);
    }

    @Override
    public void removeBlobs(String container, Iterable<String> names) {
        for (String name : names) {
            this.removeBlob(container, name);
        }
    }

    @Override
    public BlobAccess getBlobAccess(String container, String name) {
        return this.storageStrategy.getBlobAccess(container, name);
    }

    @Override
    public void setBlobAccess(String container, String name, BlobAccess access) {
        this.storageStrategy.setBlobAccess(container, name, access);
    }

    @Override
    public boolean deleteContainerIfEmpty(String containerName) {
        boolean returnVal = true;
        if (this.storageStrategy.containerExists(containerName)) {
            try {
                if (Iterables.isEmpty(this.storageStrategy.getBlobKeysInsideContainer(containerName, null))) {
                    this.storageStrategy.deleteContainer(containerName);
                } else {
                    returnVal = false;
                }
            }
            catch (IOException e) {
                this.logger.error(e, "An error occurred loading blobs contained into container %s", containerName);
                throw Throwables.propagate(e);
            }
        }
        return returnVal;
    }

    @Override
    public boolean containerExists(String containerName) {
        return this.storageStrategy.containerExists(containerName);
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        ArrayList<String> containers = new ArrayList<String>(this.storageStrategy.getAllContainerNames());
        Collections.sort(containers);
        return new PageSetImpl<StorageMetadata>(FluentIterable.from(containers).transform(new Function<String, StorageMetadata>(){

            @Override
            public StorageMetadata apply(String name) {
                return LocalBlobStore.this.storageStrategy.getContainerMetadata(name);
            }
        }).filter(Predicates.notNull()), null);
    }

    @Override
    public boolean createContainerInLocation(Location location, String name) {
        return this.storageStrategy.createContainerInLocation(name, location, CreateContainerOptions.NONE);
    }

    @Override
    public ContainerAccess getContainerAccess(String container) {
        return this.storageStrategy.getContainerAccess(container);
    }

    @Override
    public void setContainerAccess(String container, ContainerAccess access) {
        this.storageStrategy.setContainerAccess(container, access);
    }

    private Blob loadBlob(String container, String key) {
        this.logger.debug("Opening blob in container: %s - %s", container, key);
        return this.storageStrategy.getBlob(container, key);
    }

    private static HttpResponseException returnResponseException(int code) {
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(code)).build();
        return new HttpResponseException(new HttpCommand(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET")).endpoint("http://stub")).build()), response);
    }

    @Override
    public String putBlob(String containerName, Blob blob) {
        return this.putBlob(containerName, blob, PutOptions.NONE);
    }

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        Date lastModified;
        Blob blob = this.getBlob(fromContainer, fromName);
        if (blob == null) {
            throw new KeyNotFoundException(fromContainer, fromName, "while copying");
        }
        String eTag = blob.getMetadata().getETag();
        if (eTag != null) {
            eTag = LocalBlobStore.maybeQuoteETag(eTag);
            if (options.ifMatch() != null && !LocalBlobStore.maybeQuoteETag(options.ifMatch()).equals(eTag)) {
                throw LocalBlobStore.returnResponseException(412);
            }
            if (options.ifNoneMatch() != null && LocalBlobStore.maybeQuoteETag(options.ifNoneMatch()).equals(eTag)) {
                throw LocalBlobStore.returnResponseException(412);
            }
        }
        if ((lastModified = blob.getMetadata().getLastModified()) != null) {
            if (options.ifModifiedSince() != null && lastModified.compareTo(options.ifModifiedSince()) <= 0) {
                throw LocalBlobStore.returnResponseException(412);
            }
            if (options.ifUnmodifiedSince() != null && lastModified.compareTo(options.ifUnmodifiedSince()) >= 0) {
                throw LocalBlobStore.returnResponseException(412);
            }
        }
        InputStream is = null;
        try {
            ContentMetadata contentMetadata;
            is = blob.getPayload().openStream();
            MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
            BlobBuilder.PayloadBlobBuilder builder = this.blobBuilder(toName).payload(is);
            Long contentLength = metadata.getContentLength();
            if (contentLength != null) {
                builder.contentLength(contentLength);
            }
            if ((contentMetadata = options.contentMetadata()) != null) {
                String contentType;
                String contentLanguage;
                String contentEncoding;
                String contentDisposition;
                String cacheControl = contentMetadata.getCacheControl();
                if (cacheControl != null) {
                    builder.cacheControl(cacheControl);
                }
                if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
                    builder.contentDisposition(contentDisposition);
                }
                if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                    builder.contentEncoding(contentEncoding);
                }
                if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                    builder.contentLanguage(contentLanguage);
                }
                if ((contentType = contentMetadata.getContentType()) != null) {
                    builder.contentType(contentType);
                }
            } else {
                builder.cacheControl(metadata.getCacheControl()).contentDisposition(metadata.getContentDisposition()).contentEncoding(metadata.getContentEncoding()).contentLanguage(metadata.getContentLanguage()).contentType(metadata.getContentType());
            }
            Map<String, String> userMetadata = options.userMetadata();
            if (userMetadata != null) {
                builder.userMetadata(userMetadata);
            } else {
                builder.userMetadata(blob.getMetadata().getUserMetadata());
            }
            String string = this.putBlob(toContainer, builder.build());
            return string;
        }
        catch (IOException ioe) {
            throw Throwables.propagate(ioe);
        }
        finally {
            Closeables2.closeQuietly(is);
        }
    }

    private void copyPayloadHeadersToBlob(Payload payload, Blob blob) {
        blob.getAllHeaders().putAll(this.contentMetadataCodec.toHeaders(payload.getContentMetadata()));
    }

    @Override
    public boolean blobExists(String containerName, String key) {
        if (!this.storageStrategy.containerExists(containerName)) {
            throw this.cnfe(containerName);
        }
        return this.storageStrategy.blobExists(containerName, key);
    }

    @Override
    public Blob getBlob(String containerName, String key, GetOptions options) {
        Payload payload;
        this.logger.debug("Retrieving blob with key %s from container %s", key, containerName);
        if (!this.storageStrategy.containerExists(containerName)) {
            this.logger.debug("Container %s does not exist", containerName);
            throw this.cnfe(containerName);
        }
        Blob blob = this.loadBlob(containerName, key);
        if (blob == null) {
            this.logger.debug("Item %s does not exist in container %s", key, containerName);
            return null;
        }
        if (options != null) {
            String eTag = blob.getMetadata().getETag();
            if (eTag != null) {
                eTag = LocalBlobStore.maybeQuoteETag(eTag);
                if (options.getIfMatch() != null && !eTag.equals(LocalBlobStore.maybeQuoteETag(options.getIfMatch()))) {
                    throw LocalBlobStore.returnResponseException(412);
                }
                if (options.getIfNoneMatch() != null && eTag.equals(LocalBlobStore.maybeQuoteETag(options.getIfNoneMatch()))) {
                    throw LocalBlobStore.returnResponseException(304);
                }
            }
            if (options.getIfModifiedSince() != null) {
                Date modifiedSince = options.getIfModifiedSince();
                if (blob.getMetadata().getLastModified().before(modifiedSince)) {
                    HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(304)).build();
                    throw new HttpResponseException(String.format("%1$s is before %2$s", blob.getMetadata().getLastModified(), modifiedSince), null, response);
                }
            }
            if (options.getIfUnmodifiedSince() != null) {
                Date unmodifiedSince = options.getIfUnmodifiedSince();
                if (blob.getMetadata().getLastModified().after(unmodifiedSince)) {
                    HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(412)).build();
                    throw new HttpResponseException(String.format("%1$s is after %2$s", blob.getMetadata().getLastModified(), unmodifiedSince), null, response);
                }
            }
            blob = this.copyBlob(blob);
            if (options.getRanges() != null && !options.getRanges().isEmpty()) {
                ByteSource byteSource;
                long size = 0L;
                ImmutableList.Builder streams = ImmutableList.builder();
                Object object = blob.getPayload().getRawContent();
                if (object instanceof ByteSource) {
                    byteSource = (ByteSource)object;
                } else if (object instanceof byte[]) {
                    byteSource = ByteSource.wrap((byte[])object);
                } else {
                    try {
                        byteSource = ByteSource.wrap(ByteStreams2.toByteArrayAndClose(blob.getPayload().openStream()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                for (String s : options.getRanges()) {
                    long offset = 0L;
                    long last = blob.getPayload().getContentMetadata().getContentLength() - 1L;
                    if (s.startsWith("-")) {
                        offset = last - Long.parseLong(s.substring(1)) + 1L;
                        if (offset < 0L) {
                            offset = 0L;
                        }
                    } else if (s.endsWith("-")) {
                        offset = Long.parseLong(s.substring(0, s.length() - 1));
                    } else if (s.contains("-")) {
                        String[] firstLast = s.split("\\-");
                        offset = Long.parseLong(firstLast[0]);
                        last = Long.parseLong(firstLast[1]);
                    } else {
                        throw new HttpResponseException("illegal range: " + s, null, ((HttpResponse.Builder)HttpResponse.builder().statusCode(416)).build());
                    }
                    if (offset >= blob.getPayload().getContentMetadata().getContentLength()) {
                        throw new HttpResponseException("illegal range: " + s, null, ((HttpResponse.Builder)HttpResponse.builder().statusCode(416)).build());
                    }
                    if (last + 1L > blob.getPayload().getContentMetadata().getContentLength()) {
                        last = blob.getPayload().getContentMetadata().getContentLength() - 1L;
                    }
                    streams.add(byteSource.slice(offset, last - offset + 1L));
                    size += last - offset + 1L;
                    blob.getAllHeaders().put("Content-Range", "bytes " + offset + "-" + last + "/" + blob.getPayload().getContentMetadata().getContentLength());
                }
                MutableContentMetadata cmd = blob.getPayload().getContentMetadata();
                blob.setPayload(ByteSource.concat(streams.build()));
                HttpUtils.copy(cmd, blob.getPayload().getContentMetadata());
                blob.getPayload().getContentMetadata().setContentLength(size);
                blob.getMetadata().setSize(size);
            }
        }
        Preconditions.checkNotNull(blob.getPayload(), "payload " + blob);
        try {
            InputStream is = blob.getPayload().openStream();
            if (is instanceof FileInputStream) {
                is.close();
                payload = blob.getPayload();
            } else {
                blob.resetPayload(false);
                payload = new InputStreamPayload(is);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        payload.setContentMetadata(blob.getMetadata().getContentMetadata());
        blob.setPayload(payload);
        this.copyPayloadHeadersToBlob(blob.getPayload(), blob);
        return blob;
    }

    @Override
    public BlobMetadata blobMetadata(String containerName, String key) {
        try {
            Blob blob = this.getBlob(containerName, key);
            return blob != null ? BlobStoreUtils.copy(blob.getMetadata()) : null;
        }
        catch (RuntimeException e) {
            if (Iterables.size(Iterables.filter(Throwables.getCausalChain(e), KeyNotFoundException.class)) >= 1) {
                return null;
            }
            throw e;
        }
    }

    private Blob copyBlob(Blob blob) {
        Blob returnVal = this.blobFactory.create(BlobStoreUtils.copy(blob.getMetadata()));
        returnVal.setPayload(blob.getPayload());
        this.copyPayloadHeadersToBlob(blob.getPayload(), returnVal);
        return returnVal;
    }

    private boolean deleteAndVerifyContainerGone(String container) {
        this.storageStrategy.deleteContainer(container);
        return this.storageStrategy.containerExists(container);
    }

    @Override
    public String putBlob(String containerName, Blob blob, PutOptions options) {
        Preconditions.checkNotNull(containerName, "containerName must be set");
        Preconditions.checkNotNull(blob, "blob must be set");
        String blobKey = blob.getMetadata().getName();
        this.logger.debug("Put blob with key [%s] to container [%s]", blobKey, containerName);
        if (!this.storageStrategy.containerExists(containerName)) {
            throw this.cnfe(containerName);
        }
        try {
            String eTag = this.storageStrategy.putBlob(containerName, blob, options.getBlobAccess());
            return eTag;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("MD5 hash code mismatch")) {
                HttpResponseException exception = LocalBlobStore.returnResponseException(400);
                exception.initCause(e);
                throw exception;
            }
            this.logger.error(e, "An error occurred storing the new blob with name [%s] to container [%s].", blobKey, containerName);
            throw Throwables.propagate(e);
        }
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        return this.storageStrategy.createContainerInLocation(container, location, options);
    }

    @Override
    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        String uploadId = UUID.randomUUID().toString();
        Blob blob = this.blobBuilder(MULTIPART_PREFIX + uploadId + "-" + blobMetadata.getName() + "-stub").payload(ByteSource.empty()).build();
        this.putBlob(container, blob);
        return MultipartUpload.create(container, blobMetadata.getName(), uploadId, blobMetadata, options);
    }

    @Override
    public void abortMultipartUpload(MultipartUpload mpu) {
        List<MultipartPart> parts = this.listMultipartUpload(mpu);
        for (MultipartPart part : parts) {
            this.removeBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-" + part.partNumber());
        }
        this.removeBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-stub");
    }

    @Override
    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        Tier tier;
        Date expires;
        String contentType;
        String contentLanguage;
        String contentEncoding;
        String contentDisposition;
        ImmutableList.Builder blobs = ImmutableList.builder();
        long contentLength = 0L;
        Hasher md5Hasher = Hashing.md5().newHasher();
        for (MultipartPart part : parts) {
            Blob blobPart = this.getBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-" + part.partNumber());
            contentLength += blobPart.getMetadata().getContentMetadata().getContentLength().longValue();
            blobs.add(blobPart);
            if (blobPart.getMetadata().getETag() == null) continue;
            md5Hasher.putBytes(BaseEncoding.base16().lowerCase().decode(blobPart.getMetadata().getETag()));
        }
        String mpuETag = "\"" + md5Hasher.hash() + "-" + parts.size() + "\"";
        BlobBuilder.PayloadBlobBuilder blobBuilder = this.blobBuilder(mpu.blobName()).userMetadata(mpu.blobMetadata().getUserMetadata()).payload(new MultiBlobInputStream((List<Blob>)((Object)blobs.build()))).contentLength(contentLength).eTag(mpuETag);
        String cacheControl = mpu.blobMetadata().getContentMetadata().getCacheControl();
        if (cacheControl != null) {
            blobBuilder.cacheControl(cacheControl);
        }
        if ((contentDisposition = mpu.blobMetadata().getContentMetadata().getContentDisposition()) != null) {
            blobBuilder.contentDisposition(contentDisposition);
        }
        if ((contentEncoding = mpu.blobMetadata().getContentMetadata().getContentEncoding()) != null) {
            blobBuilder.contentEncoding(contentEncoding);
        }
        if ((contentLanguage = mpu.blobMetadata().getContentMetadata().getContentLanguage()) != null) {
            blobBuilder.contentLanguage(contentLanguage);
        }
        if ((contentType = mpu.blobMetadata().getContentMetadata().getContentType()) != null) {
            blobBuilder.contentType(contentType);
        }
        if ((expires = mpu.blobMetadata().getContentMetadata().getExpires()) != null) {
            blobBuilder.expires(expires);
        }
        if ((tier = mpu.blobMetadata().getTier()) != null) {
            blobBuilder.tier(tier);
        }
        this.putBlob(mpu.containerName(), blobBuilder.build());
        for (MultipartPart part : parts) {
            this.removeBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-" + part.partNumber());
        }
        this.removeBlob(mpu.containerName(), MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-stub");
        this.setBlobAccess(mpu.containerName(), mpu.blobName(), mpu.putOptions().getBlobAccess());
        return mpuETag;
    }

    @Override
    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        String partName = MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-" + partNumber;
        Blob blob = this.blobBuilder(partName).payload(payload).build();
        String partETag = this.putBlob(mpu.containerName(), blob);
        BlobMetadata metadata = this.blobMetadata(mpu.containerName(), partName);
        long partSize = metadata.getContentMetadata().getContentLength();
        return MultipartPart.create(partNumber, partSize, partETag, metadata.getLastModified());
    }

    @Override
    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder parts = ImmutableList.builder();
        ListContainerOptions options = new ListContainerOptions().prefix(MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-").recursive();
        while (true) {
            PageSet<? extends StorageMetadata> pageSet = this.list(mpu.containerName(), options);
            for (StorageMetadata storageMetadata : pageSet) {
                if (storageMetadata.getName().endsWith("-stub")) continue;
                int partNumber = Integer.parseInt(storageMetadata.getName().substring((MULTIPART_PREFIX + mpu.id() + "-" + mpu.blobName() + "-").length()));
                long partSize = storageMetadata.getSize();
                parts.add(MultipartPart.create(partNumber, partSize, storageMetadata.getETag(), storageMetadata.getLastModified()));
            }
            if (pageSet.isEmpty() || pageSet.getNextMarker() == null) break;
            options.afterMarker(pageSet.getNextMarker());
        }
        return parts.build();
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String container) {
        ImmutableList.Builder mpus = ImmutableList.builder();
        ListContainerOptions options = new ListContainerOptions().prefix(MULTIPART_PREFIX).recursive();
        int uuidLength = UUID.randomUUID().toString().length();
        while (true) {
            PageSet<? extends StorageMetadata> pageSet = this.list(container, options);
            for (StorageMetadata storageMetadata : pageSet) {
                if (!storageMetadata.getName().endsWith("-stub")) continue;
                String uploadId = storageMetadata.getName().substring(MULTIPART_PREFIX.length(), MULTIPART_PREFIX.length() + uuidLength);
                String blobName = storageMetadata.getName().substring(MULTIPART_PREFIX.length() + uuidLength + 1);
                int index = blobName.lastIndexOf(45);
                blobName = blobName.substring(0, index);
                mpus.add(MultipartUpload.create(container, blobName, uploadId, null, null));
            }
            if (pageSet.isEmpty() || pageSet.getNextMarker() == null) break;
            options.afterMarker(pageSet.getNextMarker());
        }
        return mpus.build();
    }

    @Override
    public long getMinimumMultipartPartSize() {
        return 1L;
    }

    @Override
    public long getMaximumMultipartPartSize() {
        return 0x500000L;
    }

    @Override
    public int getMaximumNumberOfParts() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void downloadBlob(String container, String name, File destination) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void downloadBlob(String container, String name, File destination, ExecutorService executor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream streamBlob(String container, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream streamBlob(String container, String name, ExecutorService executor) {
        throw new UnsupportedOperationException();
    }

    private static String maybeQuoteETag(String eTag) {
        if (!eTag.startsWith("\"") && !eTag.endsWith("\"")) {
            eTag = "\"" + eTag + "\"";
        }
        return eTag;
    }

    private static final class MultiBlobInputStream
    extends InputStream {
        private final Iterator<Blob> blobs;
        private InputStream current;

        MultiBlobInputStream(List<Blob> blobs) {
            this.blobs = blobs.iterator();
        }

        @Override
        public int read() throws IOException {
            int result;
            while (true) {
                if (this.current == null) {
                    if (!this.blobs.hasNext()) {
                        return -1;
                    }
                    this.current = this.blobs.next().getPayload().openStream();
                }
                if ((result = this.current.read()) != -1) break;
                this.current.close();
                this.current = null;
            }
            return result & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result;
            while (true) {
                if (this.current == null) {
                    if (!this.blobs.hasNext()) {
                        return -1;
                    }
                    this.current = this.blobs.next().getPayload().openStream();
                }
                if ((result = this.current.read(b, off, len)) != -1) break;
                this.current.close();
                this.current = null;
            }
            return result;
        }
    }

    private static class CommonPrefixes
    implements Function<StorageMetadata, String> {
        private final String prefix;
        private final String delimiter;
        public static final String NO_PREFIX = "NO_PREFIX";

        public CommonPrefixes(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        @Override
        public String apply(StorageMetadata metadata) {
            String working = metadata.getName();
            if (this.prefix != null) {
                if (working.startsWith(this.prefix)) {
                    working = working.substring(this.prefix.length());
                } else {
                    return NO_PREFIX;
                }
            }
            if (working.indexOf(this.delimiter) >= 0) {
                return working.substring(0, working.indexOf(this.delimiter));
            }
            return NO_PREFIX;
        }
    }

    private static class DelimiterFilter
    implements Predicate<StorageMetadata> {
        private final String prefix;
        private final String delimiter;

        public DelimiterFilter(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        @Override
        public boolean apply(StorageMetadata metadata) {
            String name = metadata.getName();
            if (this.prefix == null || this.prefix.isEmpty()) {
                return name.indexOf(this.delimiter) == -1;
            }
            if (name.startsWith(this.prefix)) {
                String unprefixedName = name.substring(this.prefix.length());
                if (unprefixedName.equals("")) {
                    return true;
                }
                return unprefixedName.indexOf(this.delimiter) == -1;
            }
            return false;
        }
    }
}

