/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.inject.internal;

import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.Cache;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.RemovalCause;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.RemovalNotification;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.LinkedHashMultiset;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multiset;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.com.google.inject.Key;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Errors;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.State;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.util.SourceProvider;

final class WeakKeySet {
    private Map<Key<?>, Multiset<Object>> backingMap;
    private final Object lock;
    private final Cache<State, Set<KeyAndSource>> evictionCache = CacheBuilder.newBuilder().weakKeys().removalListener(this::cleanupOnRemoval).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupOnRemoval(RemovalNotification<State, Set<KeyAndSource>> notification) {
        Preconditions.checkState(RemovalCause.COLLECTED.equals((Object)notification.getCause()));
        Object object = this.lock;
        synchronized (object) {
            for (KeyAndSource keyAndSource : (Set)notification.getValue()) {
                Multiset<Object> set = this.backingMap.get(keyAndSource.key);
                if (set == null) continue;
                set.remove(keyAndSource.source);
                if (!set.isEmpty()) continue;
                this.backingMap.remove(keyAndSource.key);
            }
        }
    }

    WeakKeySet(Object lock) {
        this.lock = lock;
    }

    public void add(Key<?> key, State state, Object source) {
        if (this.backingMap == null) {
            this.backingMap = Maps.newHashMap();
        }
        if (source instanceof Class || source == SourceProvider.UNKNOWN_SOURCE) {
            source = null;
        }
        Object convertedSource = Errors.convert(source);
        this.backingMap.computeIfAbsent(key, k -> LinkedHashMultiset.create()).add(convertedSource);
        if (state.parent() != State.NONE) {
            Set<KeyAndSource> keyAndSources = this.evictionCache.getIfPresent(state);
            if (keyAndSources == null) {
                keyAndSources = Sets.newHashSet();
                this.evictionCache.put(state, keyAndSources);
            }
            keyAndSources.add(new KeyAndSource(key, convertedSource));
        }
    }

    public boolean contains(Key<?> key) {
        this.evictionCache.cleanUp();
        return this.backingMap != null && this.backingMap.containsKey(key);
    }

    public Set<Object> getSources(Key<?> key) {
        this.evictionCache.cleanUp();
        Multiset<Object> sources = this.backingMap == null ? null : this.backingMap.get(key);
        return sources == null ? null : sources.elementSet();
    }

    private static final class KeyAndSource {
        final Key<?> key;
        final Object source;

        KeyAndSource(Key<?> key, Object source) {
            this.key = key;
            this.source = source;
        }

        public int hashCode() {
            return Objects.hashCode(this.key, this.source);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KeyAndSource)) {
                return false;
            }
            KeyAndSource other = (KeyAndSource)obj;
            return Objects.equal(this.key, other.key) && Objects.equal(this.source, other.source);
        }
    }
}

