/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.features;

import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Encoded;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.HeaderParam;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PUT;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloudstorage.binders.MultipartUploadBinder;
import org.jclouds.googlecloudstorage.domain.GoogleCloudStorageObject;
import org.jclouds.googlecloudstorage.domain.ListPageWithPrefixes;
import org.jclouds.googlecloudstorage.domain.RewriteResponse;
import org.jclouds.googlecloudstorage.domain.templates.ComposeObjectTemplate;
import org.jclouds.googlecloudstorage.domain.templates.ObjectTemplate;
import org.jclouds.googlecloudstorage.options.ComposeObjectOptions;
import org.jclouds.googlecloudstorage.options.CopyObjectOptions;
import org.jclouds.googlecloudstorage.options.DeleteObjectOptions;
import org.jclouds.googlecloudstorage.options.InsertObjectOptions;
import org.jclouds.googlecloudstorage.options.ListObjectOptions;
import org.jclouds.googlecloudstorage.options.RewriteObjectOptions;
import org.jclouds.googlecloudstorage.options.UpdateObjectOptions;
import org.jclouds.googlecloudstorage.parser.ParseToPayloadEnclosing;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={OAuthFilter.class})
public interface ObjectApi {
    @Named(value="Object:Exist")
    @GET
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean objectExists(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2);

    @Named(value="Object:get")
    @GET
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public GoogleCloudStorageObject getObject(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2);

    @Named(value="Object:get")
    @GET
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public GoogleCloudStorageObject getObject(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, HttpRequestOptions var3);

    @Named(value="Object:get")
    @GET
    @QueryParams(keys={"alt"}, values={"media"})
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @ResponseParser(value=ParseToPayloadEnclosing.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public PayloadEnclosing download(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2);

    @Named(value="Object:get")
    @GET
    @QueryParams(keys={"alt"}, values={"media"})
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @ResponseParser(value=ParseToPayloadEnclosing.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public PayloadEnclosing download(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, HttpRequestOptions var3);

    @Named(value="Object:simpleUpload")
    @POST
    @QueryParams(keys={"uploadType"}, values={"media"})
    @Consumes(value={"application/json"})
    @Path(value="/upload/storage/v1/b/{bucket}/o")
    public GoogleCloudStorageObject simpleUpload(@PathParam(value="bucket") String var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="Content-Length") Long var3, @PayloadParam(value="payload") Payload var4, InsertObjectOptions var5);

    @Named(value="Object:delete")
    @DELETE
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteObject(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2);

    @Named(value="Object:delete")
    @DELETE
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteObject(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, DeleteObjectOptions var3);

    @Named(value="Object:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="storage/v1/b/{bucket}/o")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListPageWithPrefixes<GoogleCloudStorageObject> listObjects(@PathParam(value="bucket") String var1);

    @Named(value="Object:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="storage/v1/b/{bucket}/o")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListPageWithPrefixes<GoogleCloudStorageObject> listObjects(@PathParam(value="bucket") String var1, ListObjectOptions var2);

    @Named(value="Object:update")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public GoogleCloudStorageObject updateObject(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ObjectTemplate var3);

    @Named(value="Object:update")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public GoogleCloudStorageObject updateObject(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ObjectTemplate var3, UpdateObjectOptions var4);

    @Named(value="Object:patch")
    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public GoogleCloudStorageObject patchObject(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ObjectTemplate var3);

    @Named(value="Object:patch")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="storage/v1/b/{bucket}/o/{object}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public GoogleCloudStorageObject patchObject(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ObjectTemplate var3, UpdateObjectOptions var4);

    @Named(value="Object:compose")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="storage/v1/b/{destinationBucket}/o/{destinationObject}/compose")
    public GoogleCloudStorageObject composeObjects(@PathParam(value="destinationBucket") String var1, @PathParam(value="destinationObject") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ComposeObjectTemplate var3);

    @Named(value="Object:compose")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="storage/v1/b/{destinationBucket}/o/{destinationObject}/compose")
    public GoogleCloudStorageObject composeObjects(@PathParam(value="destinationBucket") String var1, @PathParam(value="destinationObject") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ComposeObjectTemplate var3, ComposeObjectOptions var4);

    @Named(value="Object:copy")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/storage/v1/b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}")
    public GoogleCloudStorageObject copyObject(@PathParam(value="destinationBucket") String var1, @PathParam(value="destinationObject") @Encoded String var2, @PathParam(value="sourceBucket") String var3, @PathParam(value="sourceObject") @Encoded String var4);

    @Named(value="Object:copy")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/storage/v1/b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}")
    public GoogleCloudStorageObject copyObject(@PathParam(value="destinationBucket") String var1, @PathParam(value="destinationObject") @Encoded String var2, @PathParam(value="sourceBucket") String var3, @PathParam(value="sourceObject") @Encoded String var4, @BinderParam(value=BindToJsonPayload.class) ObjectTemplate var5);

    @Named(value="Object:copy")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/storage/v1/b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}")
    public GoogleCloudStorageObject copyObject(@PathParam(value="destinationBucket") String var1, @PathParam(value="destinationObject") @Encoded String var2, @PathParam(value="sourceBucket") String var3, @PathParam(value="sourceObject") @Encoded String var4, CopyObjectOptions var5);

    @Named(value="Object:multipartUpload")
    @POST
    @QueryParams(keys={"uploadType"}, values={"multipart"})
    @Consumes(value={"application/json"})
    @Path(value="/upload/storage/v1/b/{bucket}/o")
    @MapBinder(value=MultipartUploadBinder.class)
    public GoogleCloudStorageObject multipartUpload(@PathParam(value="bucket") String var1, @PayloadParam(value="template") ObjectTemplate var2, @PayloadParam(value="payload") Payload var3);

    @Named(value="Object:rewrite")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/storage/v1/b/{sourceBucket}/o/{sourceObject}/rewriteTo/b/{destinationBucket}/o/{destinationObject}")
    public RewriteResponse rewriteObjects(@PathParam(value="destinationBucket") String var1, @PathParam(value="destinationObject") @Encoded String var2, @PathParam(value="sourceBucket") String var3, @PathParam(value="sourceObject") @Encoded String var4);

    @Named(value="Object:rewrite")
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/storage/v1/b/{sourceBucket}/o/{sourceObject}/rewriteTo/b/{destinationBucket}/o/{destinationObject}")
    public RewriteResponse rewriteObjects(@PathParam(value="destinationBucket") String var1, @PathParam(value="destinationObject") @Encoded String var2, @PathParam(value="sourceBucket") String var3, @PathParam(value="sourceObject") @Encoded String var4, RewriteObjectOptions var5);
}

