/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.atmos.blobstore.functions.BlobMetadataToObject;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.blobstore.domain.Blob;

@Singleton
public class BlobToObject
implements Function<Blob, AtmosObject> {
    private final BlobMetadataToObject blobMd2Object;

    @Inject
    BlobToObject(BlobMetadataToObject blobMd2Object) {
        this.blobMd2Object = blobMd2Object;
    }

    @Override
    public AtmosObject apply(Blob from) {
        if (from == null) {
            return null;
        }
        AtmosObject object = this.blobMd2Object.apply(from.getMetadata());
        object.setPayload(Preconditions.checkNotNull(from.getPayload(), "payload: " + from));
        object.setAllHeaders(from.getAllHeaders());
        return object;
    }
}

