/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.config;

import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.inject.ImplementedBy;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.config.AutoValue_OAuthConfigFactory_OAuthConfig;
import org.jclouds.oauth.v2.config.OAuthScopes;

@ImplementedBy(value=OAuthConfigFromProperties.class)
@Beta
public interface OAuthConfigFactory {
    public OAuthConfig forRequest(HttpRequest var1);

    public static class OAuthConfigFromProperties
    implements OAuthConfigFactory {
        private final OAuthScopes scopes;
        @Inject(optional=true)
        @Named(value="jclouds.oauth.audience")
        private String audience;
        @Inject(optional=true)
        @Named(value="jclouds.oauth.resource")
        private String resource;

        @Inject
        OAuthConfigFromProperties(OAuthScopes scopes) {
            this.scopes = scopes;
        }

        @Override
        public OAuthConfig forRequest(HttpRequest input) {
            return OAuthConfig.create(this.scopes.forRequest(input), this.audience, this.resource);
        }
    }

    public static abstract class OAuthConfig {
        public abstract List<String> scopes();

        @Nullable
        public abstract String audience();

        @Nullable
        public abstract String resource();

        public static OAuthConfig create(List<String> scopes, String audience, String resource) {
            return new AutoValue_OAuthConfigFactory_OAuthConfig(scopes, audience, resource);
        }
    }
}

