/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.s3.domain.BucketMetadata;

@Singleton
public class BucketToResourceMetadata
implements Function<BucketMetadata, StorageMetadata> {
    private final Function<String, Location> locationOfBucket;

    @Inject
    BucketToResourceMetadata(Function<String, Location> locationOfBucket) {
        this.locationOfBucket = locationOfBucket;
    }

    @Override
    public StorageMetadata apply(BucketMetadata from) {
        MutableStorageMetadataImpl to = new MutableStorageMetadataImpl();
        to.setName(from.getName());
        to.setType(StorageType.CONTAINER);
        to.setLocation(this.locationOfBucket.apply(from.getName()));
        to.setCreationDate(from.getCreationDate());
        return to;
    }
}

