/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.auth.config;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Injector;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.auth.AuthenticationApi;
import org.jclouds.openstack.keystone.auth.config.Authentication;
import org.jclouds.openstack.keystone.auth.config.CredentialTypes;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.auth.functions.AuthenticateApiAccessKeyCredentials;
import org.jclouds.openstack.keystone.auth.functions.AuthenticatePasswordCredentials;
import org.jclouds.openstack.keystone.auth.functions.AuthenticateTokenCredentials;
import org.jclouds.openstack.keystone.auth.handlers.RetryOnRenew;
import org.jclouds.openstack.keystone.v2_0.auth.V2AuthenticationApi;
import org.jclouds.openstack.keystone.v3.auth.V3AuthenticationApi;
import org.jclouds.rest.config.BinderUtils;

public class AuthenticationModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
        BinderUtils.bindHttpApi(this.binder(), V2AuthenticationApi.class);
        BinderUtils.bindHttpApi(this.binder(), V3AuthenticationApi.class);
    }

    @Provides
    @Singleton
    protected final AuthenticationApi provideAuthenticationApi(Injector i, @Named(value="jclouds.keystone.version") String keystoneVersion) {
        return this.authenticationApis(i).get(keystoneVersion);
    }

    protected Map<String, AuthenticationApi> authenticationApis(Injector i) {
        HashMap<String, AuthenticationApi> authenticationApis = Maps.newHashMap();
        authenticationApis.put("2", i.getInstance(V2AuthenticationApi.class));
        authenticationApis.put("3", i.getInstance(V3AuthenticationApi.class));
        return authenticationApis;
    }

    @Provides
    @Singleton
    @Authentication
    protected final Supplier<String> provideAuthenticationTokenCache(final Supplier<AuthInfo> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            @Override
            public String get() {
                return ((AuthInfo)supplier.get()).getAuthToken();
            }
        };
    }

    @Provides
    @Singleton
    protected final Map<String, Function<Credentials, AuthInfo>> provideAuthenticationMethods(Injector i) {
        return this.authenticationMethods(i);
    }

    protected Map<String, Function<Credentials, AuthInfo>> authenticationMethods(Injector i) {
        ImmutableSet.Builder fns = ImmutableSet.builder();
        fns.add(i.getInstance(AuthenticatePasswordCredentials.class));
        fns.add(i.getInstance(AuthenticateApiAccessKeyCredentials.class));
        fns.add(i.getInstance(AuthenticateTokenCredentials.class));
        return CredentialTypes.indexByCredentialType(fns.build());
    }

    @Provides
    @Singleton
    protected final Function<Credentials, AuthInfo> authenticationMethodForCredentialType(@Named(value="jclouds.keystone.credential-type") String credentialType, Map<String, Function<Credentials, AuthInfo>> authenticationMethods) {
        Preconditions.checkArgument(authenticationMethods.containsKey(credentialType), "credential type %s not in supported list: %s", (Object)credentialType, authenticationMethods.keySet());
        return authenticationMethods.get(credentialType);
    }

    @Provides
    @Singleton
    public final LoadingCache<Credentials, AuthInfo> provideAuthInfoCache(Function<Credentials, AuthInfo> getAccess) {
        return CacheBuilder.newBuilder().expireAfterWrite(11L, TimeUnit.HOURS).build(CacheLoader.from(getAccess));
    }

    @Provides
    @Singleton
    protected final Supplier<AuthInfo> provideAuthInfoSupplier(final LoadingCache<Credentials, AuthInfo> cache, final @Provider Supplier<Credentials> creds) {
        return new Supplier<AuthInfo>(){

            @Override
            public AuthInfo get() {
                return (AuthInfo)cache.getUnchecked(creds.get());
            }
        };
    }
}

