/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import java.net.URI;
import java.util.Properties;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.S3BlobStoreContext;
import org.jclouds.s3.blobstore.config.S3BlobStoreContextModule;
import org.jclouds.s3.config.S3HttpApiModule;

public class S3ApiMetadata
extends BaseHttpApiMetadata {
    public Builder<?, ?> toBuilder() {
        return (Builder)new ConcreteBuilder().fromApiMetadata(this);
    }

    public S3ApiMetadata() {
        this(new ConcreteBuilder());
    }

    protected S3ApiMetadata(Builder<?, ?> builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        properties.setProperty("jclouds.s3.service-path", "/");
        properties.setProperty("jclouds.s3.virtual-host-buckets", "false");
        properties.setProperty("jclouds.relax-hostname", "true");
        properties.setProperty("jclouds.blobstore.directorysuffix", "/");
        properties.setProperty("jclouds.blobstore.metaprefix", String.format("x-${%s}-meta-", "jclouds.aws.header.tag"));
        properties.setProperty("jclouds.idempotent-methods", "DELETE,GET,HEAD,OPTIONS,POST,PUT");
        properties.setProperty("jclouds.s3.chunked.size", String.valueOf(65536));
        return properties;
    }

    private static class ConcreteBuilder
    extends Builder<S3Client, ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<A extends S3Client, T extends Builder<A, T>>
    extends BaseHttpApiMetadata.Builder<A, T> {
        protected Builder() {
            this((Class)Class.class.cast(S3Client.class));
        }

        protected Builder(Class<A> syncClient) {
            super(syncClient);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("s3")).name("Amazon Simple Storage Service (S3) API")).identityName("Access Key ID")).credentialName("Secret Access Key")).defaultEndpoint("http://localhost")).documentation(URI.create("http://docs.amazonwebservices.com/AmazonS3/latest/API"))).version("2006-03-01")).defaultProperties(S3ApiMetadata.defaultProperties())).view(Reflection2.typeToken(S3BlobStoreContext.class))).defaultModules(ImmutableSet.of(S3HttpApiModule.class, S3BlobStoreContextModule.class));
        }

        @Override
        public ApiMetadata build() {
            return new S3ApiMetadata(this);
        }
    }
}

