/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ETagFromHttpResponseViaRegex
implements Function<HttpResponse, String> {
    private static final Pattern PATTERN = Pattern.compile("<ETag>([\\S&&[^<]]+)</ETag>");
    private static final String ESCAPED_QUOTE = "&quot;";
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    ETagFromHttpResponseViaRegex(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    @Override
    public String apply(HttpResponse response) {
        Matcher matcher;
        String value = null;
        String content = this.returnStringIf200.apply(response);
        if (content != null && (matcher = PATTERN.matcher(content)).find() && (value = matcher.group(1)).indexOf(ESCAPED_QUOTE) != -1) {
            value = value.replace(ESCAPED_QUOTE, "\"");
        }
        return value;
    }
}

