/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import java.util.Collection;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.jamesmurty.utils.XMLBuilder;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;

@Singleton
public class BindBucketLoggingToXmlPayload
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        BucketLogging from = (BucketLogging)payload;
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        try {
            String stringPayload = this.generateBuilder(from).asString(outputProperties);
            request.setPayload(stringPayload);
            request.getPayload().getContentMetadata().setContentType("text/xml");
            return request;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e);
            throw new RuntimeException("error transforming bucketLogging: " + from, e);
        }
    }

    protected XMLBuilder generateBuilder(BucketLogging bucketLogging) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create("BucketLoggingStatus").attr("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/").elem("LoggingEnabled");
        rootBuilder.elem("TargetBucket").text(bucketLogging.getTargetBucket());
        rootBuilder.elem("TargetPrefix").text(bucketLogging.getTargetPrefix());
        BindBucketLoggingToXmlPayload.addGrants(rootBuilder.elem("TargetGrants"), bucketLogging.getTargetGrants());
        return rootBuilder;
    }

    static void addGrants(XMLBuilder grantsBuilder, Collection<AccessControlList.Grant> grants) {
        for (AccessControlList.Grant grant : grants) {
            XMLBuilder grantBuilder = grantsBuilder.elem("Grant");
            XMLBuilder granteeBuilder = grantBuilder.elem("Grantee").attr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (grant.getGrantee() instanceof AccessControlList.GroupGrantee) {
                granteeBuilder.attr("xsi:type", "Group").elem("URI").text(grant.getGrantee().getIdentifier());
            } else if (grant.getGrantee() instanceof AccessControlList.CanonicalUserGrantee) {
                AccessControlList.CanonicalUserGrantee grantee = (AccessControlList.CanonicalUserGrantee)grant.getGrantee();
                granteeBuilder.attr("xsi:type", "CanonicalUser").elem("ID").text(grantee.getIdentifier());
                if (grantee.getDisplayName() != null) {
                    granteeBuilder.elem("DisplayName").text(grantee.getDisplayName());
                }
            } else if (grant.getGrantee() instanceof AccessControlList.EmailAddressGrantee) {
                granteeBuilder.attr("xsi:type", "AmazonCustomerByEmail").elem("EmailAddress").text(grant.getGrantee().getIdentifier());
            }
            grantBuilder.elem("Permission").text(grant.getPermission());
        }
    }
}

