/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.HEAD;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PUT;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.v1.binders.BindMetadataToHeaders;
import org.jclouds.openstack.swift.v1.binders.BindToHeaders;
import org.jclouds.openstack.swift.v1.binders.SetPayload;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.functions.ETagHeader;
import org.jclouds.openstack.swift.v1.functions.ParseObjectFromResponse;
import org.jclouds.openstack.swift.v1.functions.ParseObjectListFromResponse;
import org.jclouds.openstack.swift.v1.options.CopyOptions;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;
import org.jclouds.openstack.swift.v1.options.PutOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface ObjectApi {
    @Consumes(value={"application/json"})
    @Named(value="object:list")
    @GET
    @ResponseParser(value=ParseObjectListFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @QueryParams(keys={"format"}, values={"json"})
    @Nullable
    public ObjectList list();

    @Consumes(value={"application/json"})
    @Named(value="object:list")
    @GET
    @ResponseParser(value=ParseObjectListFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @QueryParams(keys={"format"}, values={"json"})
    @Nullable
    public ObjectList list(ListContainerOptions var1);

    @Named(value="object:put")
    @PUT
    @Path(value="/{objectName}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @ResponseParser(value=ETagHeader.class)
    public String put(@PathParam(value="objectName") String var1, @BinderParam(value=SetPayload.class) Payload var2);

    @Named(value="object:put")
    @PUT
    @Path(value="/{objectName}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @ResponseParser(value=ETagHeader.class)
    public String put(@PathParam(value="objectName") String var1, @BinderParam(value=SetPayload.class) Payload var2, PutOptions var3);

    @Named(value="object:getWithoutBody")
    @HEAD
    @Path(value="/{objectName}")
    @ResponseParser(value=ParseObjectFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SwiftObject getWithoutBody(@PathParam(value="objectName") String var1);

    @Named(value="object:get")
    @GET
    @Path(value="/{objectName}")
    @ResponseParser(value=ParseObjectFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SwiftObject get(@PathParam(value="objectName") String var1);

    @Named(value="object:get")
    @GET
    @Path(value="/{objectName}")
    @ResponseParser(value=ParseObjectFromResponse.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SwiftObject get(@PathParam(value="objectName") String var1, GetOptions var2);

    @Named(value="object:updateMetadata")
    @POST
    @Path(value="/{objectName}")
    @Produces(value={""})
    public void updateMetadata(@PathParam(value="objectName") String var1, @BinderParam(value=BindMetadataToHeaders.BindObjectMetadataToHeaders.class) Map<String, String> var2);

    @Named(value="object:updateMetadata")
    @POST
    @Path(value="/{objectName}")
    @Produces(value={""})
    public void updateHeaders(@PathParam(value="objectName") String var1, @BinderParam(value=BindToHeaders.class) Map<String, String> var2);

    @Named(value="object:deleteMetadata")
    @POST
    @Path(value="/{objectName}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteMetadata(@PathParam(value="objectName") String var1, @BinderParam(value=BindMetadataToHeaders.BindRemoveObjectMetadataToHeaders.class) Map<String, String> var2);

    @Named(value="object:delete")
    @DELETE
    @Path(value="/{objectName}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="objectName") String var1);

    @Deprecated
    @Named(value="object:copy")
    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"X-Copy-From"}, values={"/{sourceContainer}/{sourceObject}"})
    public void copy(@PathParam(value="destinationObject") String var1, @PathParam(value="sourceContainer") String var2, @PathParam(value="sourceObject") String var3);

    @Named(value="object:copy")
    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"X-Copy-From"}, values={"/{sourceContainer}/{sourceObject}"})
    public void copy(@PathParam(value="destinationObject") String var1, @PathParam(value="sourceContainer") String var2, @PathParam(value="sourceObject") String var3, CopyOptions var4);

    @Deprecated
    @Named(value="object:copy")
    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"X-Copy-From", "X-Fresh-Metadata"}, values={"/{sourceContainer}/{sourceObject}", "True"})
    public void copy(@PathParam(value="destinationObject") String var1, @PathParam(value="sourceContainer") String var2, @PathParam(value="sourceObject") String var3, @BinderParam(value=BindMetadataToHeaders.BindObjectMetadataToHeaders.class) Map<String, String> var4, @BinderParam(value=BindToHeaders.class) Map<String, String> var5);

    @Named(value="object:copy")
    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"X-Copy-From", "X-Fresh-Metadata"}, values={"/{sourceContainer}/{sourceObject}", "True"})
    public void copy(@PathParam(value="destinationObject") String var1, @PathParam(value="sourceContainer") String var2, @PathParam(value="sourceObject") String var3, @BinderParam(value=BindMetadataToHeaders.BindObjectMetadataToHeaders.class) Map<String, String> var4, @BinderParam(value=BindToHeaders.class) Map<String, String> var5, CopyOptions var6);

    @Deprecated
    @Named(value="object:copy")
    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"X-Copy-From"}, values={"/{sourceContainer}/{sourceObject}"})
    public void copyAppendMetadata(@PathParam(value="destinationObject") String var1, @PathParam(value="sourceContainer") String var2, @PathParam(value="sourceObject") String var3, @BinderParam(value=BindMetadataToHeaders.BindObjectMetadataToHeaders.class) Map<String, String> var4, @BinderParam(value=BindToHeaders.class) Map<String, String> var5);

    @Named(value="object:copy")
    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"X-Copy-From"}, values={"/{sourceContainer}/{sourceObject}"})
    public void copyAppendMetadata(@PathParam(value="destinationObject") String var1, @PathParam(value="sourceContainer") String var2, @PathParam(value="sourceObject") String var3, @BinderParam(value=BindMetadataToHeaders.BindObjectMetadataToHeaders.class) Map<String, String> var4, @BinderParam(value=BindToHeaders.class) Map<String, String> var5, CopyOptions var6);
}

