/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import java.beans.ConstructorProperties;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ForwardingSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;

public class Access
extends ForwardingSet<Service>
implements Comparable<Access>,
AuthInfo {
    private final Token token;
    private final User user;
    private final Set<Service> serviceCatalog;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAccess(this);
    }

    @ConstructorProperties(value={"token", "user", "serviceCatalog"})
    protected Access(Token token, User user, @Nullable Set<Service> serviceCatalog) {
        this.token = Preconditions.checkNotNull(token, "token");
        this.user = Preconditions.checkNotNull(user, "user");
        this.serviceCatalog = serviceCatalog == null ? ImmutableSet.of() : ImmutableSet.copyOf(serviceCatalog);
    }

    public Token getToken() {
        return this.token;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.token, this.user, this.serviceCatalog);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Access that = (Access)Access.class.cast(obj);
        return Objects.equal(this.token, that.token) && Objects.equal(this.user, that.user) && Objects.equal(this.serviceCatalog, that.serviceCatalog);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("token", this.token).add("user", this.user).add("serviceCatalog", this.serviceCatalog);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Access that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        return this.token.compareTo(that.token);
    }

    @Override
    protected Set<Service> delegate() {
        return this.serviceCatalog;
    }

    @Override
    public String getAuthToken() {
        return this.token.getId();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Token token;
        protected User user;
        protected ImmutableSet.Builder<Service> serviceCatalog = ImmutableSet.builder();

        protected abstract T self();

        public T token(Token token) {
            this.token = token;
            return this.self();
        }

        public T user(User user) {
            this.user = user;
            return this.self();
        }

        public T service(Service service) {
            this.serviceCatalog.add((Object)service);
            return this.self();
        }

        public T services(Iterable<Service> serviceCatalog) {
            this.serviceCatalog.addAll((Iterable)serviceCatalog);
            return this.self();
        }

        public Access build() {
            return new Access(this.token, this.user, (Set<Service>)((Object)this.serviceCatalog.build()));
        }

        public T fromAccess(Access in) {
            return ((Builder)((Builder)this.token(in.getToken())).user(in.getUser())).services(in);
        }
    }
}

