/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import java.net.URI;
import java.util.Date;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.Invokable;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.options.GetOptions;
import org.jclouds.location.Provider;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;

@Singleton
public class AtmosBlobRequestSigner
implements BlobRequestSigner {
    private static final int DEFAULT_EXPIRY_SECONDS = 900;
    private final Function<Invocation, HttpRequest> processor;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Invokable<?, ?> getMethod;
    private final Invokable<?, ?> deleteMethod;
    private final Invokable<?, ?> createMethod;
    private final SignRequest signer;
    private final URI endpoint;
    private final String identity;
    private final DateService dateService;
    private final org.apache.pulsar.jcloud.shade.com.google.inject.Provider<String> timeStampProvider;

    @Inject
    public AtmosBlobRequestSigner(Function<Invocation, HttpRequest> processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2ObjectGetOptions, SignRequest signer, @Provider Supplier<URI> endpointProvider, @Provider Supplier<Credentials> creds, DateService dateService, @TimeStamp org.apache.pulsar.jcloud.shade.com.google.inject.Provider<String> timeStampProvider) throws SecurityException, NoSuchMethodException {
        this.processor = Preconditions.checkNotNull(processor, "processor");
        this.blobToObject = Preconditions.checkNotNull(blobToObject, "blobToObject");
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
        this.getMethod = Reflection2.method(AtmosClient.class, "readFile", String.class, GetOptions[].class);
        this.deleteMethod = Reflection2.method(AtmosClient.class, "deletePath", String.class);
        this.createMethod = Reflection2.method(AtmosClient.class, "createFile", String.class, AtmosObject.class, PutOptions[].class);
        this.signer = signer;
        this.endpoint = endpointProvider.get();
        this.identity = creds.get().identity;
        this.dateService = dateService;
        this.timeStampProvider = timeStampProvider;
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, 900L);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return this.sign("GET", "/rest/namespace/" + container + "/" + name, timeInSeconds);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(blob, "blob");
        return BlobStoreUtils.cleanRequest(this.processor.apply(Invocation.create(this.createMethod, ImmutableList.of(container, this.blobToObject.apply(blob)))));
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    private String getPath(String container, String name) {
        return Preconditions.checkNotNull(container, "container") + "/" + Preconditions.checkNotNull(name, "name");
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return BlobStoreUtils.cleanRequest(this.processor.apply(Invocation.create(this.getMethod, ImmutableList.of(this.getPath(container, name), this.blob2ObjectGetOptions.apply(Preconditions.checkNotNull(options, "options"))))));
    }

    private HttpRequest sign(String method, String path, long timeInSeconds) {
        Date now = this.dateService.rfc1123DateParse(this.timeStampProvider.get());
        String expires = String.valueOf(now.getTime() / 1000L + timeInSeconds);
        String stringToSign = method + "\n" + path + "\n" + this.identity + "\n" + expires;
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method(method)).endpoint(Uris.uriBuilder(this.endpoint.getScheme() + "://" + this.endpoint.getHost()).appendPath(path).build())).addQueryParam("uid", this.identity)).addQueryParam("expires", expires)).addQueryParam("signature", this.signer.calculateSignature(stringToSign))).build();
    }
}

