/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.inject.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Binder;
import org.apache.pulsar.jcloud.shade.com.google.inject.Binding;
import org.apache.pulsar.jcloud.shade.com.google.inject.Key;
import org.apache.pulsar.jcloud.shade.com.google.inject.MembersInjector;
import org.apache.pulsar.jcloud.shade.com.google.inject.Module;
import org.apache.pulsar.jcloud.shade.com.google.inject.PrivateBinder;
import org.apache.pulsar.jcloud.shade.com.google.inject.PrivateModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provider;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scope;
import org.apache.pulsar.jcloud.shade.com.google.inject.Stage;
import org.apache.pulsar.jcloud.shade.com.google.inject.TypeLiteral;
import org.apache.pulsar.jcloud.shade.com.google.inject.binder.AnnotatedBindingBuilder;
import org.apache.pulsar.jcloud.shade.com.google.inject.binder.AnnotatedConstantBindingBuilder;
import org.apache.pulsar.jcloud.shade.com.google.inject.binder.AnnotatedElementBuilder;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.AbstractBindingBuilder;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.BindingBuilder;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ConstantBindingBuilderImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.Errors;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ExposureBuilder;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.InternalFlags;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.MoreTypes;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.PrivateElementsImpl;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.ProviderMethodsModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.util.SourceProvider;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.util.StackTraceElements;
import org.apache.pulsar.jcloud.shade.com.google.inject.matcher.Matcher;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.BindingTargetVisitor;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.DefaultBindingTargetVisitor;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.Dependency;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.DisableCircularProxiesOption;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.Element;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ElementSource;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.InjectionRequest;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.InstanceBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.InterceptorBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.MembersInjectorLookup;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.Message;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ModuleAnnotatedMethodScanner;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ModuleSource;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ProviderLookup;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ProvisionListener;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ProvisionListenerBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.RequireAtInjectOnConstructorsOption;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.RequireExactBindingAnnotationsOption;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.RequireExplicitBindingsOption;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.ScopeBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.StaticInjectionRequest;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.TypeConverter;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.TypeConverterBinding;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.TypeListener;
import org.apache.pulsar.jcloud.shade.com.google.inject.spi.TypeListenerBinding;

public final class Elements {
    private static final BindingTargetVisitor<Object, Object> GET_INSTANCE_VISITOR = new DefaultBindingTargetVisitor<Object, Object>(){

        @Override
        public Object visit(InstanceBinding<?> binding) {
            return binding.getInstance();
        }

        @Override
        protected Object visitOther(Binding<?> binding) {
            throw new IllegalArgumentException();
        }
    };

    public static List<Element> getElements(Module ... modules) {
        return Elements.getElements(Stage.DEVELOPMENT, Arrays.asList(modules));
    }

    public static List<Element> getElements(Stage stage, Module ... modules) {
        return Elements.getElements(stage, Arrays.asList(modules));
    }

    public static List<Element> getElements(Iterable<? extends Module> modules) {
        return Elements.getElements(Stage.DEVELOPMENT, modules);
    }

    public static List<Element> getElements(Stage stage, Iterable<? extends Module> modules) {
        RecordingBinder binder = new RecordingBinder(stage);
        for (Module module : modules) {
            binder.install(module);
        }
        binder.scanForAnnotatedMethods();
        for (RecordingBinder recordingBinder : binder.privateBinders) {
            recordingBinder.scanForAnnotatedMethods();
        }
        StackTraceElements.clearCache();
        return Collections.unmodifiableList(binder.elements);
    }

    public static Module getModule(Iterable<? extends Element> elements) {
        return new ElementsAsModule(elements);
    }

    static <T> BindingTargetVisitor<T, T> getInstanceVisitor() {
        return GET_INSTANCE_VISITOR;
    }

    private static class RecordingBinder
    implements Binder,
    PrivateBinder {
        private final Stage stage;
        private final Map<Module, ModuleInfo> modules;
        private final List<Element> elements;
        private final Object source;
        private ModuleSource moduleSource = null;
        private final SourceProvider sourceProvider;
        private final Set<ModuleAnnotatedMethodScanner> scanners;
        private final RecordingBinder parent;
        private final PrivateElementsImpl privateElements;
        private final List<RecordingBinder> privateBinders;

        private RecordingBinder(Stage stage) {
            this.stage = stage;
            this.modules = Maps.newLinkedHashMap();
            this.scanners = Sets.newLinkedHashSet();
            this.elements = Lists.newArrayList();
            this.source = null;
            this.sourceProvider = SourceProvider.DEFAULT_INSTANCE.plusSkippedClasses(Elements.class, RecordingBinder.class, AbstractModule.class, ConstantBindingBuilderImpl.class, AbstractBindingBuilder.class, BindingBuilder.class);
            this.parent = null;
            this.privateElements = null;
            this.privateBinders = Lists.newArrayList();
        }

        private RecordingBinder(RecordingBinder prototype, Object source, SourceProvider sourceProvider) {
            Preconditions.checkArgument(source == null ^ sourceProvider == null);
            this.stage = prototype.stage;
            this.modules = prototype.modules;
            this.elements = prototype.elements;
            this.scanners = prototype.scanners;
            this.source = source;
            this.moduleSource = prototype.moduleSource;
            this.sourceProvider = sourceProvider;
            this.parent = prototype.parent;
            this.privateElements = prototype.privateElements;
            this.privateBinders = prototype.privateBinders;
        }

        private RecordingBinder(RecordingBinder parent, PrivateElementsImpl privateElements) {
            this.stage = parent.stage;
            this.modules = Maps.newLinkedHashMap();
            this.scanners = Sets.newLinkedHashSet(parent.scanners);
            this.elements = privateElements.getElementsMutable();
            this.source = parent.source;
            this.moduleSource = parent.moduleSource;
            this.sourceProvider = parent.sourceProvider;
            this.parent = parent;
            this.privateElements = privateElements;
            this.privateBinders = parent.privateBinders;
        }

        @Override
        public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
            this.elements.add(new InterceptorBinding(this.getElementSource(), classMatcher, methodMatcher, interceptors));
        }

        @Override
        public void bindScope(Class<? extends Annotation> annotationType, Scope scope) {
            this.elements.add(new ScopeBinding(this.getElementSource(), annotationType, scope));
        }

        @Override
        public void requestInjection(Object instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.requestInjection(TypeLiteral.get(instance.getClass()), instance);
        }

        @Override
        public <T> void requestInjection(TypeLiteral<T> type, T instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.elements.add(new InjectionRequest<T>(this.getElementSource(), MoreTypes.canonicalizeForKey(type), instance));
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
            MembersInjectorLookup<T> element = new MembersInjectorLookup<T>(this.getElementSource(), MoreTypes.canonicalizeForKey(typeLiteral));
            this.elements.add(element);
            return element.getMembersInjector();
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
            return this.getMembersInjector(TypeLiteral.get(type));
        }

        @Override
        public void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
            this.elements.add(new TypeListenerBinding(this.getElementSource(), listener, typeMatcher));
        }

        @Override
        public void bindListener(Matcher<? super Binding<?>> bindingMatcher, ProvisionListener ... listeners) {
            this.elements.add(new ProvisionListenerBinding(this.getElementSource(), bindingMatcher, listeners));
        }

        @Override
        public void requestStaticInjection(Class<?> ... types) {
            for (Class<?> type : types) {
                this.elements.add(new StaticInjectionRequest(this.getElementSource(), type));
            }
        }

        void scanForAnnotatedMethods() {
            for (ModuleAnnotatedMethodScanner scanner : this.scanners) {
                for (Map.Entry<Module, ModuleInfo> entry : Maps.newLinkedHashMap(this.modules).entrySet()) {
                    Module module = entry.getKey();
                    ModuleInfo info = entry.getValue();
                    if (info.skipScanning) continue;
                    this.moduleSource = entry.getValue().moduleSource;
                    try {
                        info.binder.install(ProviderMethodsModule.forModule(module, scanner));
                    }
                    catch (RuntimeException e) {
                        Collection<Message> messages = Errors.getMessagesFromThrowable(e);
                        if (!messages.isEmpty()) {
                            this.elements.addAll(messages);
                            continue;
                        }
                        this.addError(e);
                    }
                }
            }
            this.moduleSource = null;
        }

        @Override
        public void install(Module module) {
            if (!this.modules.containsKey(module)) {
                RecordingBinder binder = this;
                boolean unwrapModuleSource = false;
                if (module instanceof ProviderMethodsModule) {
                    Class<?> delegateClass = ((ProviderMethodsModule)module).getDelegateModuleClass();
                    if (this.moduleSource == null || !this.moduleSource.getModuleClassName().equals(delegateClass.getName())) {
                        this.moduleSource = this.getModuleSource(delegateClass);
                        unwrapModuleSource = true;
                    }
                } else {
                    this.moduleSource = this.getModuleSource(module.getClass());
                    unwrapModuleSource = true;
                }
                boolean skipScanning = false;
                if (module instanceof PrivateModule) {
                    binder = (RecordingBinder)binder.newPrivateBinder();
                    binder.modules.put(module, new ModuleInfo(binder, this.moduleSource, false));
                    skipScanning = true;
                }
                this.modules.put(module, new ModuleInfo(binder, this.moduleSource, skipScanning));
                try {
                    module.configure(binder);
                }
                catch (RuntimeException e) {
                    Collection<Message> messages = Errors.getMessagesFromThrowable(e);
                    if (!messages.isEmpty()) {
                        this.elements.addAll(messages);
                    }
                    this.addError(e);
                }
                binder.install(ProviderMethodsModule.forModule(module));
                if (unwrapModuleSource) {
                    this.moduleSource = this.moduleSource.getParent();
                }
            }
        }

        @Override
        public Stage currentStage() {
            return this.stage;
        }

        @Override
        public void addError(String message, Object ... arguments) {
            this.elements.add(new Message(this.getElementSource(), Errors.format(message, arguments)));
        }

        @Override
        public void addError(Throwable t) {
            String message = "An exception was caught and reported. Message: " + t.getMessage();
            this.elements.add(new Message(ImmutableList.of(this.getElementSource()), message, t));
        }

        @Override
        public void addError(Message message) {
            this.elements.add(message);
        }

        public <T> AnnotatedBindingBuilder<T> bind(Key<T> key) {
            BindingBuilder<T> builder = new BindingBuilder<T>(this, this.elements, this.getElementSource(), MoreTypes.canonicalizeKey(key));
            return builder;
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
            return this.bind((Key)Key.get(typeLiteral));
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(Class<T> type) {
            return this.bind((Key)Key.get(type));
        }

        @Override
        public AnnotatedConstantBindingBuilder bindConstant() {
            return new ConstantBindingBuilderImpl(this, this.elements, this.getElementSource());
        }

        @Override
        public <T> Provider<T> getProvider(Key<T> key) {
            return this.getProvider(Dependency.get(key));
        }

        @Override
        public <T> Provider<T> getProvider(Dependency<T> dependency) {
            ProviderLookup<T> element = new ProviderLookup<T>((Object)this.getElementSource(), dependency);
            this.elements.add(element);
            return element.getProvider();
        }

        @Override
        public <T> Provider<T> getProvider(Class<T> type) {
            return this.getProvider(Key.get(type));
        }

        @Override
        public void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
            this.elements.add(new TypeConverterBinding(this.getElementSource(), typeMatcher, converter));
        }

        @Override
        public RecordingBinder withSource(Object source) {
            return source == this.source ? this : new RecordingBinder(this, source, null);
        }

        @Override
        public RecordingBinder skipSources(Class ... classesToSkip) {
            if (this.source != null) {
                return this;
            }
            SourceProvider newSourceProvider = this.sourceProvider.plusSkippedClasses(classesToSkip);
            return new RecordingBinder(this, null, newSourceProvider);
        }

        @Override
        public PrivateBinder newPrivateBinder() {
            PrivateElementsImpl privateElements = new PrivateElementsImpl(this.getElementSource());
            RecordingBinder binder = new RecordingBinder(this, privateElements);
            this.privateBinders.add(binder);
            this.elements.add(privateElements);
            return binder;
        }

        @Override
        public void disableCircularProxies() {
            this.elements.add(new DisableCircularProxiesOption(this.getElementSource()));
        }

        @Override
        public void requireExplicitBindings() {
            this.elements.add(new RequireExplicitBindingsOption(this.getElementSource()));
        }

        @Override
        public void requireAtInjectOnConstructors() {
            this.elements.add(new RequireAtInjectOnConstructorsOption(this.getElementSource()));
        }

        @Override
        public void requireExactBindingAnnotations() {
            this.elements.add(new RequireExactBindingAnnotationsOption(this.getElementSource()));
        }

        @Override
        public void scanModulesForAnnotatedMethods(ModuleAnnotatedMethodScanner scanner) {
            this.scanners.add(scanner);
            this.elements.add(new ModuleAnnotatedMethodScannerBinding(this.getElementSource(), scanner));
        }

        @Override
        public void expose(Key<?> key) {
            this.exposeInternal(key);
        }

        @Override
        public AnnotatedElementBuilder expose(Class<?> type) {
            return this.exposeInternal(Key.get(type));
        }

        @Override
        public AnnotatedElementBuilder expose(TypeLiteral<?> type) {
            return this.exposeInternal(Key.get(type));
        }

        private <T> AnnotatedElementBuilder exposeInternal(Key<T> key) {
            if (this.privateElements == null) {
                this.addError("Cannot expose %s on a standard binder. Exposed bindings are only applicable to private binders.", key);
                return new AnnotatedElementBuilder(){

                    @Override
                    public void annotatedWith(Class<? extends Annotation> annotationType) {
                    }

                    @Override
                    public void annotatedWith(Annotation annotation) {
                    }
                };
            }
            ExposureBuilder<T> builder = new ExposureBuilder<T>(this, this.getElementSource(), MoreTypes.canonicalizeKey(key));
            this.privateElements.addExposureBuilder(builder);
            return builder;
        }

        private ModuleSource getModuleSource(Class<?> module) {
            StackTraceElement[] partialCallStack = InternalFlags.getIncludeStackTraceOption() == InternalFlags.IncludeStackTraceOption.COMPLETE ? this.getPartialCallStack(new Throwable().getStackTrace()) : new StackTraceElement[]{};
            if (this.moduleSource == null) {
                return new ModuleSource(module, partialCallStack);
            }
            return this.moduleSource.createChild(module, partialCallStack);
        }

        private ElementSource getElementSource() {
            InternalFlags.IncludeStackTraceOption stackTraceOption;
            StackTraceElement[] callStack = null;
            StackTraceElement[] partialCallStack = new StackTraceElement[]{};
            ElementSource originalSource = null;
            Object declaringSource = this.source;
            if (declaringSource instanceof ElementSource) {
                originalSource = (ElementSource)declaringSource;
                declaringSource = originalSource.getDeclaringSource();
            }
            if ((stackTraceOption = InternalFlags.getIncludeStackTraceOption()) == InternalFlags.IncludeStackTraceOption.COMPLETE || stackTraceOption == InternalFlags.IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE && declaringSource == null) {
                callStack = new Throwable().getStackTrace();
            }
            if (stackTraceOption == InternalFlags.IncludeStackTraceOption.COMPLETE) {
                partialCallStack = this.getPartialCallStack(callStack);
            }
            if (declaringSource == null) {
                declaringSource = stackTraceOption == InternalFlags.IncludeStackTraceOption.COMPLETE || stackTraceOption == InternalFlags.IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE ? this.sourceProvider.get(callStack) : this.sourceProvider.getFromClassNames(this.moduleSource.getModuleClassNames());
            }
            return new ElementSource(originalSource, declaringSource, this.moduleSource, partialCallStack);
        }

        private StackTraceElement[] getPartialCallStack(StackTraceElement[] callStack) {
            int toSkip = 0;
            if (this.moduleSource != null) {
                toSkip = this.moduleSource.getStackTraceSize();
            }
            int chunkSize = callStack.length - toSkip - 1;
            StackTraceElement[] partialCallStack = new StackTraceElement[chunkSize];
            System.arraycopy(callStack, 1, partialCallStack, 0, chunkSize);
            return partialCallStack;
        }

        public String toString() {
            return "Binder";
        }
    }

    private static class ModuleInfo {
        private final Binder binder;
        private final ModuleSource moduleSource;
        private final boolean skipScanning;

        private ModuleInfo(Binder binder, ModuleSource moduleSource, boolean skipScanning) {
            this.binder = binder;
            this.moduleSource = moduleSource;
            this.skipScanning = skipScanning;
        }
    }

    private static class ElementsAsModule
    implements Module {
        private final Iterable<? extends Element> elements;

        ElementsAsModule(Iterable<? extends Element> elements) {
            this.elements = elements;
        }

        @Override
        public void configure(Binder binder) {
            for (Element element : this.elements) {
                element.applyTo(binder);
            }
        }
    }
}

