/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.features;

import java.util.List;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Encoded;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PUT;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Produces;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloudstorage.domain.ObjectAccessControls;
import org.jclouds.googlecloudstorage.domain.templates.ObjectAccessControlsTemplate;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface ObjectAccessControlsApi {
    @Named(value="ObjectAccessControls:get")
    @GET
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ObjectAccessControls getObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3);

    @Named(value="ObjectAccessControls:get")
    @GET
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ObjectAccessControls getObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @QueryParam(value="generation") Long var4);

    @Named(value="ObjectAccessControls:insert")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl")
    public ObjectAccessControls createObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var3);

    @Named(value="ObjectAccessControls:insert")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl")
    public ObjectAccessControls createObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var3, @QueryParam(value="generation") Long var4);

    @Named(value="ObjectAccessControls:delete")
    @DELETE
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public void deleteObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3);

    @Named(value="ObjectAccessControls:delete")
    @DELETE
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public void deleteObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @QueryParam(value="generation") Long var4);

    @Named(value="ObjectAccessControls:list")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl")
    @SelectJson(value={"items"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public List<ObjectAccessControls> listObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2);

    @Named(value="ObjectAccessControls:list")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl")
    @SelectJson(value={"items"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public List<ObjectAccessControls> listObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @QueryParam(value="generation") Long var3);

    @Named(value="ObjectAccessControls:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public ObjectAccessControls updateObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var4);

    @Named(value="ObjectAccessControls:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public ObjectAccessControls updateObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var4, @QueryParam(value="generation") Long var5);

    @Named(value="ObjectAccessControls:patch")
    @PATCH
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public ObjectAccessControls patchObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var4);

    @Named(value="ObjectAccessControls:patch")
    @PATCH
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public ObjectAccessControls patchObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var4, @QueryParam(value="generation") Long var5);
}

