/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.config;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scopes;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.azure.storage.config.AuthType;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.AzureBlobRequestSigner;
import org.jclouds.azureblob.blobstore.AzureBlobStore;
import org.jclouds.azureblob.config.InsufficientAccessRightsException;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.attr.ConsistencyModel;

public class AzureBlobStoreContextModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.STRICT);
        this.bind(BlobStore.class).to(AzureBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobRequestSigner.class).to(AzureBlobRequestSigner.class);
    }

    @Provides
    @Singleton
    protected final LoadingCache<String, PublicAccess> containerAcls(final AzureBlobClient client, final @Named(value="sasAuth") boolean sasAuthentication, final AuthType authType) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(new CacheLoader<String, PublicAccess>(){

            @Override
            public PublicAccess load(String container) throws CacheLoader.InvalidCacheLoadException {
                if (!sasAuthentication && authType == AuthType.AZURE_KEY) {
                    return client.getPublicAccessForContainer(container);
                }
                throw new InsufficientAccessRightsException("SAS Authentication does not support getAcl and setAcl calls.");
            }

            public String toString() {
                return "getPublicAccessForContainer()";
            }
        });
    }
}

