/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog.functions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;
import org.jclouds.openstack.keystone.catalog.functions.BaseEndpointResolutionStrategy;

@Singleton
public class PublicURLOrInternal
extends BaseEndpointResolutionStrategy {
    private static final Comparator<ServiceEndpoint> PublicInterfacesFirst = new Comparator<ServiceEndpoint>(){

        @Override
        public int compare(ServiceEndpoint left, ServiceEndpoint right) {
            if (ServiceEndpoint.Interface.PUBLIC.equals((Object)left.iface())) {
                return -1;
            }
            if (ServiceEndpoint.Interface.PUBLIC.equals((Object)right.iface())) {
                return 1;
            }
            return 0;
        }
    };

    @Override
    public Supplier<URI> apply(Collection<ServiceEndpoint> input) {
        ArrayList<ServiceEndpoint> publicEndpointsFirst = new ArrayList<ServiceEndpoint>(input);
        Collections.sort(publicEndpointsFirst, PublicInterfacesFirst);
        return super.apply((Collection<ServiceEndpoint>)publicEndpointsFirst);
    }

    @Override
    protected Predicate<ServiceEndpoint> filter() {
        return Predicates.or(PublicURLOrInternal.withIface(ServiceEndpoint.Interface.PUBLIC), PublicURLOrInternal.withIface(ServiceEndpoint.Interface.INTERNAL));
    }
}

