/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.MoreExecutors;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.concurrent.config.WithSubmissionTrace;
import org.jclouds.lifecycle.Closer;

public class ScheduledExecutorServiceModule
extends AbstractModule {
    @Provides
    @Singleton
    @Named(value="jclouds.scheduler-threads")
    final ListeningScheduledExecutorService provideListeningScheduledExecutorService(@Named(value="jclouds.scheduler-threads") int count, Closer closer) {
        return ExecutorServiceModule.shutdownOnClose(WithSubmissionTrace.wrap(ScheduledExecutorServiceModule.newScheduledThreadPoolNamed("scheduler thread %d", count)), closer);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.scheduler-threads")
    final ScheduledExecutorService provideScheduledExecutor(@Named(value="jclouds.scheduler-threads") ListeningScheduledExecutorService in) {
        return in;
    }

    private static ListeningScheduledExecutorService newScheduledThreadPoolNamed(String name, int maxCount) {
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat(name).setThreadFactory(Executors.defaultThreadFactory()).build();
        return MoreExecutors.listeningDecorator(maxCount == 0 ? Executors.newSingleThreadScheduledExecutor(factory) : Executors.newScheduledThreadPool(maxCount, factory));
    }

    @Override
    protected void configure() {
    }
}

