/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.filters;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.b2.domain.Authorization;
import org.jclouds.collect.Memoized;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public final class RequestAuthorization
implements HttpRequestFilter {
    private final Supplier<Authorization> auth;

    @Inject
    RequestAuthorization(@Memoized Supplier<Authorization> auth) {
        this.auth = auth;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Authorization auth = this.auth.get();
        URI endpoint = request.getEndpoint();
        endpoint = URI.create(auth.apiUrl() + (endpoint.getPort() == -1 ? "" : ":" + endpoint.getPort()) + endpoint.getPath() + (endpoint.getQuery() == null ? "" : "?" + endpoint.getQuery()));
        request = ((HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(endpoint)).replaceHeader("Authorization", auth.authorizationToken())).build();
        return request;
    }
}

