/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.common.primitives.Ints;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.functions.AzureBlobToBlob;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.azureblob.blobstore.functions.ListBlobsResponseToResourceList;
import org.jclouds.azureblob.blobstore.functions.ListOptionsToListBlobsOptions;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobBlockProperties;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobBlocksResponse;
import org.jclouds.azureblob.domain.ListBlobsInclude;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.options.CopyBlobOptions;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;

@Singleton
public class AzureBlobStore
extends BaseBlobStore {
    private final AzureBlobClient sync;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions;
    private final ListBlobsResponseToResourceList azure2BlobStoreResourceList;
    private final AzureBlobToBlob azureBlob2Blob;
    private final BlobToAzureBlob blob2AzureBlob;
    private final BlobPropertiesToBlobMetadata blob2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;

    @Inject
    AzureBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, AzureBlobClient sync, ContainerToResourceMetadata container2ResourceMd, ListOptionsToListBlobsOptions blobStore2AzureContainerListOptions, ListBlobsResponseToResourceList azure2BlobStoreResourceList, AzureBlobToBlob azureBlob2Blob, BlobToAzureBlob blob2AzureBlob, BlobPropertiesToBlobMetadata blob2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.sync = Preconditions.checkNotNull(sync, "sync");
        this.container2ResourceMd = Preconditions.checkNotNull(container2ResourceMd, "container2ResourceMd");
        this.blobStore2AzureContainerListOptions = Preconditions.checkNotNull(blobStore2AzureContainerListOptions, "blobStore2AzureContainerListOptions");
        this.azure2BlobStoreResourceList = Preconditions.checkNotNull(azure2BlobStoreResourceList, "azure2BlobStoreResourceList");
        this.azureBlob2Blob = Preconditions.checkNotNull(azureBlob2Blob, "azureBlob2Blob");
        this.blob2AzureBlob = Preconditions.checkNotNull(blob2AzureBlob, "blob2AzureBlob");
        this.blob2BlobMd = Preconditions.checkNotNull(blob2BlobMd, "blob2BlobMd");
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        return new Function<BoundedSet<ContainerProperties>, PageSet<? extends StorageMetadata>>(){

            @Override
            public PageSet<? extends StorageMetadata> apply(BoundedSet<ContainerProperties> from) {
                return new PageSetImpl<StorageMetadata>(Iterables.transform(from, AzureBlobStore.this.container2ResourceMd), from.getNextMarker());
            }
        }.apply(this.sync.listContainers(ListOptions.Builder.includeMetadata()));
    }

    @Override
    public boolean containerExists(String container) {
        return this.sync.containerExists(container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container) {
        return this.sync.createContainer(container, new CreateContainerOptions[0]);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListBlobsOptions azureOptions = this.blobStore2AzureContainerListOptions.apply(options);
        return this.azure2BlobStoreResourceList.apply(this.sync.listBlobs(container, azureOptions.includeMetadata()));
    }

    @Override
    public void deleteContainer(String container) {
        this.sync.deleteContainer(container);
    }

    @Override
    public boolean blobExists(String container, String key) {
        return this.sync.blobExists(container, key);
    }

    @Override
    public Blob getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions azureOptions = this.blob2ObjectGetOptions.apply(options);
        return this.azureBlob2Blob.apply(this.sync.getBlob(container, key, azureOptions));
    }

    @Override
    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, new PutOptions());
    }

    @Override
    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.getBlobAccess() != BlobAccess.PRIVATE) {
            throw new UnsupportedOperationException("blob access not supported by Azure");
        }
        String eTag = options.isMultipart() ? this.putMultipartBlob(container, blob, options) : this.sync.putBlob(container, this.blob2AzureBlob.apply(blob));
        Tier tier = blob.getMetadata().getTier();
        if (tier != Tier.STANDARD) {
            this.sync.setBlobTier(container, blob.getMetadata().getName(), AccessTier.fromTier(tier));
        }
        return eTag;
    }

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        Map<String, String> userMetadata;
        CopyBlobOptions.Builder azureOptions = CopyBlobOptions.builder();
        if (options.ifMatch() != null) {
            azureOptions.ifMatch(options.ifMatch());
        }
        if (options.ifNoneMatch() != null) {
            azureOptions.ifNoneMatch(options.ifNoneMatch());
        }
        if (options.ifModifiedSince() != null) {
            azureOptions.ifModifiedSince(options.ifModifiedSince());
        }
        if (options.ifUnmodifiedSince() != null) {
            azureOptions.ifUnmodifiedSince(options.ifUnmodifiedSince());
        }
        if ((userMetadata = options.userMetadata()) != null) {
            azureOptions.overrideUserMetadata(userMetadata);
        }
        URI source = this.context.getSigner().signGetBlob(fromContainer, fromName).getEndpoint();
        String eTag = this.sync.copyBlob(source, toContainer, toName, azureOptions.build());
        ContentMetadata contentMetadata = options.contentMetadata();
        if (contentMetadata != null) {
            String contentType;
            String contentLanguage;
            String contentEncoding;
            String contentDisposition;
            ContentMetadataBuilder builder = ContentMetadataBuilder.create();
            String cacheControl = contentMetadata.getCacheControl();
            if (cacheControl != null) {
                builder.cacheControl(cacheControl);
            }
            if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
                builder.contentDisposition(contentDisposition);
            }
            if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                builder.contentEncoding(contentEncoding);
            }
            if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                builder.contentLanguage(contentLanguage);
            }
            if ((contentType = contentMetadata.getContentType()) != null) {
                builder.contentType(contentType);
            }
            eTag = this.sync.setBlobProperties(toContainer, toName, builder.build());
        }
        return eTag;
    }

    @Override
    public void removeBlob(String container, String key) {
        this.sync.deleteBlob(container, key);
    }

    public void putBlock(String container, String name, String blockId, Payload block) {
        this.sync.putBlock(container, name, blockId, block);
    }

    public String putBlockList(String container, String name, List<String> blockIdList) {
        return this.sync.putBlockList(container, name, blockIdList);
    }

    public ListBlobBlocksResponse getBlockList(String container, String name) {
        return this.sync.getBlockList(container, name);
    }

    @Override
    public BlobMetadata blobMetadata(String container, String key) {
        return this.blob2BlobMd.apply(this.sync.getBlobProperties(container, key));
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        if (!this.list(container).isEmpty()) {
            return false;
        }
        this.sync.deleteContainer(container);
        return true;
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, org.jclouds.blobstore.options.CreateContainerOptions options) {
        CreateContainerOptions createContainerOptions = new CreateContainerOptions();
        if (options.isPublicRead()) {
            createContainerOptions.withPublicAccess(PublicAccess.CONTAINER);
        }
        return this.sync.createContainer(container, createContainerOptions);
    }

    @Override
    public ContainerAccess getContainerAccess(String container) {
        PublicAccess access = this.sync.getPublicAccessForContainer(container);
        if (access == PublicAccess.CONTAINER) {
            return ContainerAccess.PUBLIC_READ;
        }
        return ContainerAccess.PRIVATE;
    }

    @Override
    public void setContainerAccess(String container, ContainerAccess access) {
        PublicAccess publicAccess = access == ContainerAccess.PUBLIC_READ ? PublicAccess.CONTAINER : PublicAccess.PRIVATE;
        this.sync.setPublicAccessForContainer(container, publicAccess);
    }

    @Override
    public BlobAccess getBlobAccess(String container, String key) {
        return BlobAccess.PRIVATE;
    }

    @Override
    public void setBlobAccess(String container, String key, BlobAccess access) {
        throw new UnsupportedOperationException("unsupported in Azure");
    }

    @Override
    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        String uploadId = UUID.randomUUID().toString();
        return MultipartUpload.create(container, blobMetadata.getName(), uploadId, blobMetadata, options);
    }

    @Override
    public void abortMultipartUpload(MultipartUpload mpu) {
    }

    @Override
    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        AzureBlob azureBlob = this.sync.newBlob();
        azureBlob.setPayload(new byte[0]);
        azureBlob.getProperties().setContainer(mpu.containerName());
        azureBlob.getProperties().setName(mpu.blobName());
        azureBlob.getProperties().setContentMetadata((MutableContentMetadata)mpu.blobMetadata().getContentMetadata());
        azureBlob.getProperties().setMetadata(mpu.blobMetadata().getUserMetadata());
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (MultipartPart part : parts) {
            String blockId = BaseEncoding.base64().encode(Ints.toByteArray(part.partNumber()));
            blocks.add(blockId);
        }
        return this.sync.putBlockList(mpu.containerName(), azureBlob, (List<String>)((Object)blocks.build()));
    }

    @Override
    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        String blockId = BaseEncoding.base64().encode(Ints.toByteArray(partNumber));
        this.sync.putBlock(mpu.containerName(), mpu.blobName(), blockId, payload);
        String eTag = "";
        Object lastModified = null;
        return MultipartPart.create(partNumber, payload.getContentMetadata().getContentLength(), eTag);
    }

    @Override
    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ListBlobBlocksResponse response;
        try {
            response = this.sync.getBlockList(mpu.containerName(), mpu.blobName());
        }
        catch (KeyNotFoundException knfe) {
            return ImmutableList.of();
        }
        ImmutableList.Builder parts = ImmutableList.builder();
        for (BlobBlockProperties properties : response.getBlocks()) {
            int partNumber = Ints.fromByteArray(BaseEncoding.base64().decode(properties.getBlockName()));
            String eTag = "";
            Date lastModified = null;
            parts.add(MultipartPart.create(partNumber, properties.getContentLength(), eTag, lastModified));
        }
        return parts.build();
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String container) {
        ListBlobsResponse response;
        ImmutableList.Builder builder = ImmutableList.builder();
        String marker = null;
        do {
            ListBlobsOptions options = new ListBlobsOptions().include(EnumSet.of(ListBlobsInclude.UNCOMMITTEDBLOBS));
            if (marker != null) {
                options.marker(marker);
            }
            response = this.sync.listBlobs(container, options);
            for (BlobProperties properties : response) {
                if (properties.getETag() != null) continue;
                String uploadId = UUID.randomUUID().toString();
                builder.add(MultipartUpload.create(properties.getContainer(), properties.getName(), uploadId, null, null));
            }
        } while ((marker = response.getNextMarker()) != null);
        return builder.build();
    }

    @Override
    public long getMinimumMultipartPartSize() {
        return 1L;
    }

    @Override
    public long getMaximumMultipartPartSize() {
        return 0x6400000L;
    }

    @Override
    public int getMaximumNumberOfParts() {
        return 50000;
    }

    @Override
    public InputStream streamBlob(String container, String name) {
        throw new UnsupportedOperationException("Azure does not support streaming a blob");
    }
}

