/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.util.storageurl;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.azure.storage.util.storageurl.StorageUrlSupplier;
import org.jclouds.azure.storage.util.storageurl.TrailingSlashUtil;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;

@Singleton
public class AppendAccountToEndpoint
implements StorageUrlSupplier {
    private final Supplier<URI> endpointSupplier;
    private final Supplier<Credentials> credentialsSupplier;

    @Inject
    public AppendAccountToEndpoint(@Provider Supplier<URI> endpointSupplier, @Provider Supplier<Credentials> credentialsSupplier) {
        this.endpointSupplier = endpointSupplier;
        this.credentialsSupplier = credentialsSupplier;
    }

    @Override
    public URI get() {
        URI endpoint = this.endpointSupplier.get();
        Preconditions.checkNotNull(endpoint, "An endpoint must be configured in order to use AppendAccountToEndpoint module");
        String endpointTrailingSlash = TrailingSlashUtil.ensureTrailingSlash(endpoint) + this.credentialsSupplier.get().identity + "/";
        return URI.create(endpointTrailingSlash);
    }
}

