/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.predicates.fromconfig;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.location.predicates.ZoneIdFilter;
import org.jclouds.location.suppliers.fromconfig.ZoneIdsFromConfiguration;

@Singleton
public class AnyOrConfiguredZoneId
implements ZoneIdFilter {
    private ZoneIdsFromConfiguration idsInConfigSupplier;

    @Inject
    protected AnyOrConfiguredZoneId(ZoneIdsFromConfiguration idsInConfigSupplier) {
        this.idsInConfigSupplier = Preconditions.checkNotNull(idsInConfigSupplier, "idsInConfigSupplier");
    }

    @Override
    public boolean apply(String input) {
        Object idsInConfig = this.idsInConfigSupplier.get();
        if (idsInConfig.isEmpty()) {
            return true;
        }
        return idsInConfig.contains(input);
    }

    public String toString() {
        return "anyOrConfiguredZoneId(" + this.idsInConfigSupplier + ")";
    }
}

