/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.config;

import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.MapMaker;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.TypeLiteral;
import org.apache.pulsar.jcloud.shade.com.google.inject.name.Names;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.logging.Logger;

public class SSLModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(HostnameVerifier.class).annotatedWith(Names.named("untrusted")).to(LogToMapHostnameVerifier.class);
        this.bind(new TypeLiteral<Supplier<SSLContext>>(){}).annotatedWith(Names.named("untrusted")).to((TypeLiteral<Supplier<SSLContext>>)new TypeLiteral<UntrustedSSLContextSupplier>(){});
        this.bind(X509TrustManager.class).annotatedWith(Names.named("untrusted")).to(TrustAllCerts.class);
    }

    @Singleton
    public static class TrustAllCerts
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    @Singleton
    public static class UntrustedSSLContextSupplier
    implements Supplier<SSLContext> {
        private final SSLContext sslContext;

        @Inject
        UntrustedSSLContextSupplier(TrustAllCerts trustAllCerts) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{trustAllCerts}, new SecureRandom());
                this.sslContext = sslContext;
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public SSLContext get() {
            return this.sslContext;
        }
    }

    @Singleton
    public static class LogToMapHostnameVerifier
    implements HostnameVerifier {
        @Resource
        private Logger logger = Logger.NULL;
        private final Map<String, String> sslMap = new MapMaker().makeMap();

        @Override
        public boolean verify(String hostname, SSLSession session) {
            String oldPeerHost;
            String peerHost = session.getPeerHost();
            if (!(hostname.equals(peerHost) || (oldPeerHost = this.sslMap.get(hostname)) != null && oldPeerHost.equals(peerHost))) {
                this.logger.warn("hostname was %s while session was %s", hostname, peerHost);
                this.sslMap.put(hostname, peerHost);
            }
            return true;
        }
    }
}

