/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import java.beans.ConstructorProperties;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.jclouds.openstack.v2_0.domain.Limit;

public final class RateLimit {
    private final String uri;
    private final String regex;
    @Named(value="limit")
    private final Iterable<Limit> limits;

    @ConstructorProperties(value={"uri", "regex", "limit"})
    private RateLimit(String uri, String regex, Iterable<Limit> limits) {
        this.uri = Preconditions.checkNotNull(uri, "uri");
        this.regex = Preconditions.checkNotNull(regex, "regex");
        this.limits = Preconditions.checkNotNull(limits, "limit");
    }

    public String getUri() {
        return this.uri;
    }

    public String getRegex() {
        return this.regex;
    }

    public Iterable<Limit> getLimits() {
        return this.limits;
    }

    public int hashCode() {
        return Objects.hashCode(this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RateLimit that = (RateLimit)RateLimit.class.cast(obj);
        return Objects.equal(this.uri, that.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("uri", this.uri).add("regex", this.regex).add("limits", this.limits).toString();
    }
}

