/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.domain.MutableObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadata;

public class ParseObjectMetadataFromHeaders
implements Function<HttpResponse, MutableObjectMetadata>,
InvocationContext<ParseObjectMetadataFromHeaders> {
    private final ParseSystemAndUserMetadataFromHeaders blobMetadataParser;
    private final BlobToObjectMetadata blobToObjectMetadata;
    private final String userMdPrefix;
    static final Pattern MD5_FROM_ETAG = Pattern.compile("^\"?([0-9a-f]+)\"?$");

    @Inject
    public ParseObjectMetadataFromHeaders(ParseSystemAndUserMetadataFromHeaders blobMetadataParser, BlobToObjectMetadata blobToObjectMetadata, @Named(value="jclouds.blobstore.metaprefix") String userMdPrefix) {
        this.blobMetadataParser = blobMetadataParser;
        this.blobToObjectMetadata = blobToObjectMetadata;
        this.userMdPrefix = userMdPrefix;
    }

    @Override
    public MutableObjectMetadata apply(HttpResponse from) {
        Matcher md5Matcher;
        MutableBlobMetadata base = this.blobMetadataParser.apply(from);
        MutableObjectMetadata to = this.blobToObjectMetadata.apply(base);
        this.addETagTo(from, to);
        if (to.getContentMetadata().getContentMD5() == null && to.getETag() != null && (md5Matcher = MD5_FROM_ETAG.matcher(to.getETag())).find()) {
            byte[] md5 = BaseEncoding.base16().lowerCase().decode(md5Matcher.group(1));
            if (from.getPayload() != null) {
                from.getPayload().getContentMetadata().setContentMD5(md5);
            }
            to.getContentMetadata().setContentMD5(md5);
        }
        to.getUserMetadata().remove("object-etag");
        to.setCacheControl(from.getFirstHeaderOrNull("Cache-Control"));
        String storageClass = from.getFirstHeaderOrNull("x-amz-storage-class");
        if (storageClass != null) {
            to.setStorageClass(ObjectMetadata.StorageClass.valueOf(storageClass));
        }
        return to;
    }

    @VisibleForTesting
    protected void addETagTo(HttpResponse from, MutableObjectMetadata metadata) {
        String eTagHeader;
        if (metadata.getETag() == null && (eTagHeader = from.getFirstHeaderOrNull(this.userMdPrefix + "object-eTag")) != null) {
            metadata.setETag(eTagHeader);
        }
    }

    @Override
    public ParseObjectMetadataFromHeaders setContext(HttpRequest request) {
        this.blobMetadataParser.setContext(request);
        this.blobToObjectMetadata.setContext(request);
        return this;
    }

    public ParseObjectMetadataFromHeaders setKey(String key) {
        this.blobMetadataParser.setName(key);
        return this;
    }
}

