/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.proxy;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.proxy.ProxyConfig;

@Singleton
public class ProxyForURI
implements Function<URI, Proxy> {
    private final ProxyConfig config;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-for-sockets")
    private boolean useProxyForSockets = true;

    @Inject
    @VisibleForTesting
    ProxyForURI(ProxyConfig config) {
        this.config = Preconditions.checkNotNull(config, "config");
    }

    @Override
    public Proxy apply(URI endpoint) {
        if (!this.useProxyForSockets && "socket".equals(endpoint.getScheme())) {
            return Proxy.NO_PROXY;
        }
        if (this.config.getProxy().isPresent()) {
            InetSocketAddress addr = new InetSocketAddress(this.config.getProxy().get().getHostText(), this.config.getProxy().get().getPort());
            Proxy proxy = new Proxy(this.config.getType(), addr);
            final Optional<Credentials> creds = this.config.getCredentials();
            if (creds.isPresent()) {
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(((Credentials)creds.get()).identity, ((Credentials)creds.get()).credential.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
            return proxy;
        }
        if (this.config.isJvmProxyEnabled()) {
            return this.getDefaultProxy(endpoint);
        }
        if (this.config.useSystem()) {
            System.setProperty("java.net.useSystemProxies", "true");
            return this.getDefaultProxy(endpoint);
        }
        return Proxy.NO_PROXY;
    }

    private Proxy getDefaultProxy(URI endpoint) {
        List<Proxy> proxies = ProxySelector.getDefault().select(endpoint);
        return Iterables.getLast(proxies);
    }
}

