/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.blobstore;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.com.google.inject.assistedinject.Assisted;
import org.apache.pulsar.jcloud.shade.com.google.inject.name.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Provider;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.options.GetOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Region;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.TemporaryUrlSigner;

public class RegionScopedTemporaryUrlBlobSigner
implements BlobRequestSigner {
    private static final long DEFAULT_SIGNING_TIMEOUT = TimeUnit.MINUTES.toSeconds(15L);
    private final BlobToHttpGetOptions toGetOptions = new BlobToHttpGetOptions();
    private final Provider<Long> timestamp;
    private final TemporaryUrlSigner signer;
    private final URI storageUrl;

    @Inject
    protected RegionScopedTemporaryUrlBlobSigner(@Region Supplier<Map<String, Supplier<URI>>> regionToUris, @Named(value="jclouds.session-interval") long seconds, @TimeStamp Provider<Long> timestamp, SwiftApi api, @Assisted String regionId) {
        Preconditions.checkNotNull(regionId, "regionId");
        this.timestamp = timestamp;
        this.signer = TemporaryUrlSigner.checkApiEvery(api.getAccountApi(regionId), seconds);
        this.storageUrl = regionToUris.get().get(regionId).get();
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, DEFAULT_SIGNING_TIMEOUT);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        return this.sign("GET", container, name, GetOptions.NONE, this.timestamp.get() + timeInSeconds, null);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        return this.sign("GET", container, name, this.toGetOptions.apply(options), this.timestamp.get() + DEFAULT_SIGNING_TIMEOUT, null);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        return this.signPutBlob(container, blob, DEFAULT_SIGNING_TIMEOUT);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        return this.sign("PUT", container, blob.getMetadata().getName(), GetOptions.NONE, this.timestamp.get() + timeInSeconds, blob.getMetadata().getContentMetadata().getContentType());
    }

    private HttpRequest sign(String method, String container, String name, GetOptions options, long expires, @Nullable String contentType) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        URI url = Uris.uriBuilder(this.storageUrl).appendPath(container).appendPath(name).build();
        String signature = this.signer.sign(method, url.getPath(), expires);
        HttpRequest.Builder builder = (HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method(method)).endpoint(url)).addQueryParams(options.buildQueryParameters())).addQueryParam("temp_url_sig", signature)).addQueryParam("temp_url_expires", String.valueOf(expires))).headers(options.buildRequestHeaders());
        if (contentType != null) {
            builder.replaceHeader("Content-Type", contentType);
        }
        return builder.build();
    }
}

