/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore.functions;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.googlecloudstorage.domain.DomainResourceReferences;
import org.jclouds.googlecloudstorage.domain.templates.ObjectTemplate;
import org.jclouds.io.ContentMetadata;

public class BlobMetadataToObjectTemplate
implements Function<BlobMetadata, ObjectTemplate> {
    @Override
    public ObjectTemplate apply(BlobMetadata from) {
        if (from == null) {
            return null;
        }
        String name = from.getName();
        Map<String, String> userMeta = from.getUserMetadata();
        ContentMetadata metadata = from.getContentMetadata();
        String contentDisposition = metadata.getContentDisposition();
        String contentEncoding = metadata.getContentEncoding();
        String contentLanguage = metadata.getContentLanguage();
        String contentType = metadata.getContentType();
        Long contentLength = metadata.getContentLength();
        HashCode md5 = metadata.getContentMD5AsHashCode();
        ObjectTemplate template = new ObjectTemplate().contentType(contentType).size(contentLength).contentEncoding(contentEncoding).contentLanguage(contentLanguage).contentDisposition(contentDisposition).name(name).customMetadata(userMeta).storageClass(DomainResourceReferences.StorageClass.fromTier(from.getTier()));
        if (md5 != null) {
            template.md5Hash(BaseEncoding.base64().encode(md5.asBytes()));
        }
        return template;
    }
}

