/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;

@Singleton
public class ParsePublicAccessHeader
implements Function<HttpResponse, PublicAccess> {
    @Override
    public PublicAccess apply(HttpResponse from) {
        HttpUtils.releasePayload(from);
        String access = from.getFirstHeaderOrNull("x-ms-blob-public-access");
        if (access == null) {
            return PublicAccess.PRIVATE;
        }
        return PublicAccess.valueOf(access.toUpperCase());
    }
}

