/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.filesystem.util.internal;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Provider;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.filesystem.strategy.internal.FilesystemStorageStrategyImpl;

public class FileSystemBlobUtilsImpl
implements BlobUtils {
    protected final FilesystemStorageStrategyImpl storageStrategy;
    protected final Provider<BlobBuilder> blobBuilders;

    @Inject
    public FileSystemBlobUtilsImpl(LocalStorageStrategy storageStrategy, Provider<BlobBuilder> blobBuilders) {
        this.storageStrategy = (FilesystemStorageStrategyImpl)Preconditions.checkNotNull(storageStrategy, "Filesystem Storage Strategy");
        this.blobBuilders = Preconditions.checkNotNull(blobBuilders, "Filesystem  blobBuilders");
    }

    @Override
    public BlobBuilder blobBuilder() {
        return this.blobBuilders.get();
    }

    @Override
    public boolean directoryExists(String containerName, String directory) {
        return this.storageStrategy.directoryExists(containerName, directory);
    }

    @Override
    public void createDirectory(String containerName, String directory) {
        this.storageStrategy.createDirectory(containerName, directory);
    }

    @Override
    public long countBlobs(String container, ListContainerOptions options) {
        return this.storageStrategy.countBlobs(container, options);
    }

    @Override
    public void clearContainer(String container, ListContainerOptions options) {
        this.storageStrategy.clearContainer(container, options);
    }

    @Override
    public void deleteDirectory(String container, String directory) {
        this.storageStrategy.deleteDirectory(container, directory);
    }
}

