/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.jamesmurty.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pulsar.jcloud.shade.com.jamesmurty.utils.BaseXMLBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLBuilder
extends BaseXMLBuilder {
    protected XMLBuilder(Document xmlDocument) {
        super(xmlDocument);
    }

    protected XMLBuilder(Node myNode, Node parentNode) {
        super(myNode, parentNode);
    }

    public static XMLBuilder create(String name, String namespaceURI) throws ParserConfigurationException, FactoryConfigurationError {
        return new XMLBuilder(XMLBuilder.createDocumentImpl(name, namespaceURI));
    }

    public static XMLBuilder create(String name) throws ParserConfigurationException, FactoryConfigurationError {
        return XMLBuilder.create(name, null);
    }

    public static XMLBuilder parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        return new XMLBuilder(XMLBuilder.parseDocumentImpl(inputSource));
    }

    public static XMLBuilder parse(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        return XMLBuilder.parse(new InputSource(new StringReader(xmlString)));
    }

    public static XMLBuilder parse(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        return XMLBuilder.parse(new InputSource(new FileReader(xmlFile)));
    }

    public XMLBuilder stripWhitespaceOnlyTextNodes() throws XPathExpressionException {
        super.stripWhitespaceOnlyTextNodesImpl();
        return this;
    }

    public XMLBuilder importXMLBuilder(BaseXMLBuilder builder) {
        super.importXMLBuilderImpl(builder);
        return this;
    }

    public XMLBuilder root() {
        return new XMLBuilder(this.getDocument());
    }

    public XMLBuilder xpathFind(String xpath, NamespaceContext nsContext) throws XPathExpressionException {
        Node foundNode = super.xpathFindImpl(xpath, nsContext);
        return new XMLBuilder(foundNode, null);
    }

    public XMLBuilder xpathFind(String xpath) throws XPathExpressionException {
        return this.xpathFind(xpath, null);
    }

    public XMLBuilder element(String name) {
        String namespaceURI = super.lookupNamespaceURIImpl(name);
        return this.element(name, namespaceURI);
    }

    public XMLBuilder elem(String name) {
        return this.element(name);
    }

    public XMLBuilder e(String name) {
        return this.element(name);
    }

    public XMLBuilder element(String name, String namespaceURI) {
        Element elem = super.elementImpl(name, namespaceURI);
        return new XMLBuilder(elem, this.getElement());
    }

    public XMLBuilder elementBefore(String name) {
        Element newElement = super.elementBeforeImpl(name);
        return new XMLBuilder(newElement, null);
    }

    public XMLBuilder elementBefore(String name, String namespaceURI) {
        Element newElement = super.elementBeforeImpl(name, namespaceURI);
        return new XMLBuilder(newElement, null);
    }

    public XMLBuilder attribute(String name, String value) {
        super.attributeImpl(name, value);
        return this;
    }

    public XMLBuilder attr(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder a(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder text(String value, boolean replaceText) {
        super.textImpl(value, replaceText);
        return this;
    }

    public XMLBuilder text(String value) {
        return this.text(value, false);
    }

    public XMLBuilder t(String value) {
        return this.text(value);
    }

    public XMLBuilder cdata(String data) {
        super.cdataImpl(data);
        return this;
    }

    public XMLBuilder data(String data) {
        return this.cdata(data);
    }

    public XMLBuilder d(String data) {
        return this.cdata(data);
    }

    public XMLBuilder cdata(byte[] data) {
        super.cdataImpl(data);
        return this;
    }

    public XMLBuilder data(byte[] data) {
        return this.cdata(data);
    }

    public XMLBuilder d(byte[] data) {
        return this.cdata(data);
    }

    public XMLBuilder comment(String comment) {
        super.commentImpl(comment);
        return this;
    }

    public XMLBuilder cmnt(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder c(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder instruction(String target, String data) {
        super.instructionImpl(target, data);
        return this;
    }

    public XMLBuilder inst(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder i(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder insertInstruction(String target, String data) {
        super.insertInstructionImpl(target, data);
        return this;
    }

    public XMLBuilder reference(String name) {
        super.referenceImpl(name);
        return this;
    }

    public XMLBuilder ref(String name) {
        return this.reference(name);
    }

    public XMLBuilder r(String name) {
        return this.reference(name);
    }

    public XMLBuilder namespace(String prefix, String namespaceURI) {
        super.namespaceImpl(prefix, namespaceURI);
        return this;
    }

    public XMLBuilder ns(String prefix, String namespaceURI) {
        return this.attribute(prefix, namespaceURI);
    }

    public XMLBuilder namespace(String namespaceURI) {
        this.namespace(null, namespaceURI);
        return this;
    }

    public XMLBuilder ns(String namespaceURI) {
        return this.namespace(namespaceURI);
    }

    public XMLBuilder up(int steps) {
        Node currNode = super.upImpl(steps);
        if (currNode instanceof Document) {
            return new XMLBuilder((Document)currNode);
        }
        return new XMLBuilder(currNode, null);
    }

    public XMLBuilder up() {
        return this.up(1);
    }

    public XMLBuilder document() {
        return new XMLBuilder(this.getDocument(), null);
    }
}

