/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.functions;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Charsets;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.jclouds.json.Json;
import org.jclouds.oauth.v2.config.Authorization;
import org.jclouds.oauth.v2.domain.CertificateFingerprint;
import org.jclouds.rest.AuthorizationException;

public final class ClientCredentialsClaimsToAssertion
implements Function<Object, String> {
    private static final List<String> SUPPORTED_ALGS = ImmutableList.of("RS256", "none");
    private final Supplier<PrivateKey> privateKey;
    private final Supplier<CertificateFingerprint> certFingerprint;
    private final Json json;
    private final String alg;

    @Inject
    ClientCredentialsClaimsToAssertion(@Named(value="jclouds.oauth.jws-alg") String alg, @Authorization Supplier<PrivateKey> privateKey, @Authorization Supplier<CertificateFingerprint> certFingerprint, Json json) {
        this.alg = alg;
        Preconditions.checkArgument(SUPPORTED_ALGS.contains(alg), "%s %s not in supported list", "jclouds.oauth.jws-alg", alg, SUPPORTED_ALGS);
        this.privateKey = privateKey;
        this.certFingerprint = certFingerprint;
        this.json = json;
    }

    @Override
    public String apply(Object input) {
        String encodedHeader = String.format("{\"alg\":\"%s\",\"typ\":\"JWT\",\"x5t\":\"%s\"}", this.alg, this.certFingerprint.get().fingerprint());
        String encodedClaimSet = this.json.toJson(input);
        encodedHeader = BaseEncoding.base64Url().omitPadding().encode(encodedHeader.getBytes(Charsets.UTF_8));
        encodedClaimSet = BaseEncoding.base64Url().omitPadding().encode(encodedClaimSet.getBytes(Charsets.UTF_8));
        byte[] signature = this.alg.equals("none") ? null : ClientCredentialsClaimsToAssertion.sha256(this.privateKey.get(), Joiner.on(".").join(encodedHeader, encodedClaimSet, new Object[0]).getBytes(Charsets.UTF_8));
        String encodedSignature = signature != null ? BaseEncoding.base64Url().omitPadding().encode(signature) : "";
        return Joiner.on(".").join(encodedHeader, encodedClaimSet, encodedSignature);
    }

    static byte[] sha256(PrivateKey privateKey, byte[] input) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(input);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (SignatureException e) {
            throw new AuthorizationException(e);
        }
        catch (InvalidKeyException e) {
            throw new AuthorizationException(e);
        }
    }
}

