/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ObjectArrays;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ForwardingFuture;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ForwardingListenableFuture;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ForwardingListeningExecutorService;

public class WithSubmissionTrace {
    private static final Set<String> stackTracesToTrim = ImmutableSet.of(WithSubmissionTrace.class.getName(), ListeningExecutorService.class.getName(), ListenableFuture.class.getName(), ListeningScheduledExecutorService.class.getName(), ScheduledFuture.class.getName(), ListenableScheduledFuture.class.getName(), new String[0]);

    private WithSubmissionTrace() {
    }

    public static ListeningExecutorService wrap(org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningExecutorService delegate) {
        return new ListeningExecutorService(delegate);
    }

    private static StackTraceElement[] getStackTraceHere() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return WithSubmissionTrace.filterTrace(trace);
    }

    private static StackTraceElement[] filterTrace(StackTraceElement[] trace) {
        return Iterables.toArray(Iterables.filter(Arrays.asList(trace), new Predicate<StackTraceElement>(){

            @Override
            public boolean apply(StackTraceElement input) {
                String className = input.getClassName();
                return !stackTracesToTrim.contains(className);
            }
        }), StackTraceElement.class);
    }

    private static ExecutionException addSubmissionTrace(StackTraceElement[] submissionTrace, ExecutionException e) {
        if (e.getCause() == null) {
            return WithSubmissionTrace.filterTrace(e);
        }
        Throwable cause = e.getCause();
        StackTraceElement[] combined = WithSubmissionTrace.filterTrace(ObjectArrays.concat(cause.getStackTrace(), submissionTrace, StackTraceElement.class));
        cause.setStackTrace(combined);
        return WithSubmissionTrace.filterTrace(e);
    }

    private static ExecutionException filterTrace(ExecutionException e) {
        StackTraceElement[] withoutHere = WithSubmissionTrace.filterTrace(e.getStackTrace());
        e.setStackTrace(withoutHere);
        return e;
    }

    public static ListeningScheduledExecutorService wrap(org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService delegate) {
        return new ListeningScheduledExecutorService(delegate);
    }

    private static class ListenableScheduledFuture<T>
    extends ScheduledFuture<T>
    implements org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableScheduledFuture<T> {
        private ListenableScheduledFuture(org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableScheduledFuture<T> delegate) {
            super(delegate);
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            ((org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableScheduledFuture)this.delegate()).addListener(listener, executor);
        }
    }

    private static class ScheduledFuture<T>
    extends ForwardingFuture<T>
    implements java.util.concurrent.ScheduledFuture<T> {
        private final java.util.concurrent.ScheduledFuture<T> delegate;
        private final StackTraceElement[] submissionTrace;

        private ScheduledFuture(java.util.concurrent.ScheduledFuture<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.submissionTrace = WithSubmissionTrace.getStackTraceHere();
        }

        @Override
        protected java.util.concurrent.ScheduledFuture<T> delegate() {
            return this.delegate;
        }

        @Override
        public long getDelay(TimeUnit arg0) {
            return this.delegate().getDelay(arg0);
        }

        @Override
        public int compareTo(Delayed arg0) {
            return this.delegate().compareTo(arg0);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return (T)this.delegate().get();
            }
            catch (ExecutionException e) {
                throw WithSubmissionTrace.addSubmissionTrace(this.submissionTrace, e);
            }
        }

        @Override
        public T get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return (T)this.delegate().get(arg0, arg1);
            }
            catch (ExecutionException e) {
                throw WithSubmissionTrace.addSubmissionTrace(this.submissionTrace, e);
            }
        }
    }

    private static class ListeningScheduledExecutorService
    extends ListeningExecutorService
    implements org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService {
        private ListeningScheduledExecutorService(org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService delegate) {
            super(delegate);
        }

        @Override
        protected org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService delegate() {
            return (org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService)org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService.class.cast(super.delegate());
        }

        public <T> ListenableFuture<T> submit(Callable<T> task) {
            return new ListenableFuture<T>(this.delegate().submit(task));
        }

        @Override
        public ListenableFuture<?> submit(Runnable task) {
            return new ListenableFuture(this.delegate().submit(task));
        }

        public <T> ListenableFuture<T> submit(Runnable task, T result) {
            return new ListenableFuture<T>(this.delegate().submit(task, result));
        }

        public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return new ListenableScheduledFuture(this.delegate().schedule(command, delay, unit));
        }

        public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return new ListenableScheduledFuture(this.delegate().schedule(callable, delay, unit));
        }

        public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return new ListenableScheduledFuture(this.delegate().scheduleAtFixedRate(command, initialDelay, period, unit));
        }

        public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return new ListenableScheduledFuture(this.delegate().scheduleWithFixedDelay(command, initialDelay, delay, unit));
        }
    }

    private static class ListenableFuture<T>
    extends ForwardingListenableFuture<T> {
        private final org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableFuture<T> delegate;
        private final StackTraceElement[] submissionTrace;

        ListenableFuture(org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableFuture<T> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.submissionTrace = WithSubmissionTrace.getStackTraceHere();
        }

        @Override
        protected org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableFuture<T> delegate() {
            return this.delegate;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return (T)this.delegate().get();
            }
            catch (ExecutionException e) {
                throw WithSubmissionTrace.addSubmissionTrace(this.submissionTrace, e);
            }
        }

        @Override
        public T get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return (T)this.delegate().get(arg0, arg1);
            }
            catch (ExecutionException e) {
                throw WithSubmissionTrace.addSubmissionTrace(this.submissionTrace, e);
            }
        }
    }

    private static class ListeningExecutorService
    extends ForwardingListeningExecutorService {
        private final org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningExecutorService delegate;

        private ListeningExecutorService(org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningExecutorService delegate) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        }

        @Override
        protected org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningExecutorService delegate() {
            return this.delegate;
        }

        @Override
        public <T> org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableFuture<T> submit(Callable<T> task) {
            return new ListenableFuture<T>(this.delegate().submit(task));
        }

        @Override
        public org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableFuture<?> submit(Runnable task) {
            return new ListenableFuture(this.delegate().submit(task));
        }

        @Override
        public <T> org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListenableFuture<T> submit(Runnable task, T result) {
            return new ListenableFuture<T>(this.delegate().submit(task, result));
        }
    }
}

