/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.domain;

import java.beans.ConstructorProperties;
import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;

public class Link {
    @Named(value="rel")
    private final Relation relation;
    private final Optional<String> type;
    private final URI href;

    public static Link create(Relation relation, URI href) {
        return new Link(relation, null, href);
    }

    public static Link create(Relation relation, String type, URI href) {
        return new Link(relation, Optional.fromNullable(type), href);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Link.builder().fromLink(this);
    }

    @ConstructorProperties(value={"rel", "type", "href"})
    protected Link(Relation relation, Optional<String> type, URI href) {
        this.href = Preconditions.checkNotNull(href, "href");
        this.relation = Preconditions.checkNotNull(relation, "relation of %s", href);
        this.type = type == null ? Optional.absent() : type;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Optional<String> getType() {
        return this.type;
    }

    public URI getHref() {
        return this.href;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.relation, this.type, this.href});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Link that = (Link)Link.class.cast(obj);
        return Objects.equal((Object)this.relation, (Object)that.relation) && Objects.equal(this.type, that.type) && Objects.equal(this.href, that.href);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("relation", (Object)this.relation).add("type", this.type.orNull()).add("href", this.href);
    }

    public String toString() {
        return this.string().toString();
    }

    public static class Builder {
        protected Relation relation;
        protected Optional<String> type = Optional.absent();
        protected URI href;

        public Builder relation(Relation relation) {
            this.relation = relation;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.fromNullable(type);
            return this;
        }

        public Builder href(URI href) {
            this.href = href;
            return this;
        }

        public Link build() {
            return new Link(this.relation, this.type, this.href);
        }

        public Builder fromLink(Link in) {
            return this.relation(in.getRelation()).type(in.getType().orNull()).href(in.getHref());
        }
    }

    public static enum Relation {
        SELF,
        BOOKMARK,
        DESCRIBEDBY,
        NEXT,
        PREVIOUS,
        ALTERNATE,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static Relation fromValue(String v) {
            try {
                return Relation.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

