/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public class MutableBlobMetadataImpl
extends MutableStorageMetadataImpl
implements MutableBlobMetadata {
    private MutableContentMetadata contentMetadata;
    private URI publicUri;
    private String container;
    private Tier tier;

    public MutableBlobMetadataImpl() {
        this.setType(StorageType.BLOB);
        this.contentMetadata = new BaseMutableContentMetadata();
    }

    public MutableBlobMetadataImpl(BlobMetadata from) {
        super(from);
        this.contentMetadata = new BaseMutableContentMetadata();
        HttpUtils.copy(from.getContentMetadata(), this.contentMetadata);
        this.publicUri = from.getPublicUri();
        this.container = from.getContainer();
        this.tier = from.getTier() == null ? Tier.STANDARD : from.getTier();
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public void setContentMetadata(MutableContentMetadata contentMetadata) {
        this.contentMetadata = contentMetadata;
    }

    @Override
    public void setPublicUri(URI publicUri) {
        this.publicUri = publicUri;
    }

    @Override
    public URI getPublicUri() {
        return this.publicUri;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(String container) {
        this.container = container;
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    @Override
    public void setTier(Tier tier) {
        this.tier = tier;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableBlobMetadataImpl)) {
            return false;
        }
        MutableBlobMetadataImpl that = (MutableBlobMetadataImpl)object;
        return super.equals(that) && Objects.equal(this.contentMetadata, that.contentMetadata) && Objects.equal(this.publicUri, that.publicUri) && Objects.equal(this.container, that.container) && Objects.equal((Object)this.tier, (Object)that.tier);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.contentMetadata, this.publicUri, this.container);
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return super.string().add("publicUri", this.publicUri).add("container", this.container).add("contentMetadata", this.contentMetadata).add("tier", (Object)this.tier);
    }
}

