/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableCollection;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.BlobImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.googlecloud.config.CurrentProject;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecloudstorage.GoogleCloudStorageApi;
import org.jclouds.googlecloudstorage.blobstore.functions.BlobMetadataToObjectTemplate;
import org.jclouds.googlecloudstorage.blobstore.functions.BlobStoreListContainerOptionsToListObjectOptions;
import org.jclouds.googlecloudstorage.blobstore.functions.BucketToStorageMetadata;
import org.jclouds.googlecloudstorage.blobstore.functions.ObjectListToStorageMetadata;
import org.jclouds.googlecloudstorage.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.googlecloudstorage.domain.Bucket;
import org.jclouds.googlecloudstorage.domain.DomainResourceReferences;
import org.jclouds.googlecloudstorage.domain.GoogleCloudStorageObject;
import org.jclouds.googlecloudstorage.domain.ListPageWithPrefixes;
import org.jclouds.googlecloudstorage.domain.ObjectAccessControls;
import org.jclouds.googlecloudstorage.domain.templates.BucketTemplate;
import org.jclouds.googlecloudstorage.domain.templates.ComposeObjectTemplate;
import org.jclouds.googlecloudstorage.domain.templates.ObjectAccessControlsTemplate;
import org.jclouds.googlecloudstorage.domain.templates.ObjectTemplate;
import org.jclouds.googlecloudstorage.options.InsertObjectOptions;
import org.jclouds.googlecloudstorage.options.ListObjectOptions;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.util.Strings2;

public final class GoogleCloudStorageBlobStore
extends BaseBlobStore {
    private final GoogleCloudStorageApi api;
    private final BucketToStorageMetadata bucketToStorageMetadata;
    private final ObjectToBlobMetadata objectToBlobMetadata;
    private final ObjectListToStorageMetadata objectListToStorageMetadata;
    private final BlobMetadataToObjectTemplate blobMetadataToObjectTemplate;
    private final BlobStoreListContainerOptionsToListObjectOptions listContainerOptionsToListObjectOptions;
    private final Supplier<String> projectId;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;

    @Inject
    GoogleCloudStorageBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, GoogleCloudStorageApi api, BucketToStorageMetadata bucketToStorageMetadata, ObjectToBlobMetadata objectToBlobMetadata, ObjectListToStorageMetadata objectListToStorageMetadata, BlobMetadataToObjectTemplate blobMetadataToObjectTemplate, BlobStoreListContainerOptionsToListObjectOptions listContainerOptionsToListObjectOptions, @CurrentProject Supplier<String> projectId, BlobToHttpGetOptions blob2ObjectGetOptions) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.api = api;
        this.bucketToStorageMetadata = bucketToStorageMetadata;
        this.objectToBlobMetadata = objectToBlobMetadata;
        this.objectListToStorageMetadata = objectListToStorageMetadata;
        this.blobMetadataToObjectTemplate = blobMetadataToObjectTemplate;
        this.listContainerOptionsToListObjectOptions = listContainerOptionsToListObjectOptions;
        this.projectId = projectId;
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        return new Function<ListPage<Bucket>, PageSet<? extends StorageMetadata>>(){

            @Override
            public PageSet<? extends StorageMetadata> apply(ListPage<Bucket> from) {
                return new PageSetImpl<StorageMetadata>(Iterables.transform(from, GoogleCloudStorageBlobStore.this.bucketToStorageMetadata), from.nextPageToken());
            }
        }.apply(this.api.getBucketApi().listBucket(this.projectId.get()));
    }

    @Override
    public boolean containerExists(String container) {
        return this.api.getBucketApi().bucketExist(container);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container) {
        BucketTemplate template = new BucketTemplate().name(container);
        if (location != null) {
            DomainResourceReferences.Location gcsLocation = DomainResourceReferences.Location.fromValue(location.getId());
            template = template.location(gcsLocation);
        }
        return this.api.getBucketApi().createBucket(this.projectId.get(), template) != null;
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        BucketTemplate template = new BucketTemplate().name(container);
        if (location != null) {
            DomainResourceReferences.Location gcsLocation = DomainResourceReferences.Location.fromValue(location.getId());
            template = template.location(gcsLocation);
        }
        Bucket bucket = this.api.getBucketApi().createBucket(this.projectId.get(), template);
        if (options.isPublicRead()) {
            try {
                ObjectAccessControlsTemplate doAclTemplate = ObjectAccessControlsTemplate.create("allUsers", DomainResourceReferences.ObjectRole.READER);
                this.api.getDefaultObjectAccessControlsApi().createDefaultObjectAccessControls(container, doAclTemplate);
            }
            catch (HttpResponseException e) {
                this.api.getBucketApi().deleteBucket(container);
                return false;
            }
        }
        return bucket != null;
    }

    @Override
    public ContainerAccess getContainerAccess(String container) {
        ObjectAccessControls controls = this.api.getDefaultObjectAccessControlsApi().getDefaultObjectAccessControls(container, "allUsers");
        if (controls == null || controls.role() == DomainResourceReferences.ObjectRole.OWNER) {
            return ContainerAccess.PRIVATE;
        }
        return ContainerAccess.PUBLIC_READ;
    }

    @Override
    public void setContainerAccess(String container, ContainerAccess access) {
        if (access == ContainerAccess.PUBLIC_READ) {
            ObjectAccessControlsTemplate doAclTemplate = ObjectAccessControlsTemplate.create("allUsers", DomainResourceReferences.ObjectRole.READER);
            this.api.getDefaultObjectAccessControlsApi().createDefaultObjectAccessControls(container, doAclTemplate);
        } else {
            this.api.getDefaultObjectAccessControlsApi().deleteDefaultObjectAccessControls(container, "allUsers");
        }
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container) {
        return this.list(container, ListContainerOptions.NONE);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListObjectOptions listOptions = this.listContainerOptionsToListObjectOptions.apply(options);
        ListPageWithPrefixes<GoogleCloudStorageObject> gcsList = this.api.getObjectApi().listObjects(container, listOptions);
        return this.objectListToStorageMetadata.apply(gcsList);
    }

    @Override
    public boolean blobExists(String container, String name) {
        return this.api.getObjectApi().objectExists(container, Strings2.urlEncode(name, new char[0]));
    }

    @Override
    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, PutOptions.NONE);
    }

    @Override
    public String putBlob(String container, Blob blob, PutOptions options) {
        long length = Preconditions.checkNotNull(blob.getPayload().getContentMetadata().getContentLength());
        if (length != 0L && (options.isMultipart() || !blob.getPayload().isRepeatable())) {
            return this.putMultipartBlob(container, blob, options);
        }
        ObjectTemplate template = this.blobMetadataToObjectTemplate.apply(blob.getMetadata());
        HashCode md5 = blob.getMetadata().getContentMetadata().getContentMD5AsHashCode();
        if (md5 != null) {
            template.md5Hash(BaseEncoding.base64().encode(md5.asBytes()));
        }
        if (options.getBlobAccess() == BlobAccess.PUBLIC_READ) {
            ObjectAccessControls controls = ObjectAccessControls.builder().entity("allUsers").bucket(container).role(DomainResourceReferences.ObjectRole.READER).build();
            template.addAcl(controls);
        }
        return this.api.getObjectApi().multipartUpload(container, template, blob.getPayload()).etag();
    }

    @Override
    public BlobMetadata blobMetadata(String container, String name) {
        return this.objectToBlobMetadata.apply(this.api.getObjectApi().getObject(container, Strings2.urlEncode(name, new char[0])));
    }

    @Override
    public Blob getBlob(String container, String name, GetOptions options) {
        GoogleCloudStorageObject gcsObject = this.api.getObjectApi().getObject(container, Strings2.urlEncode(name, new char[0]));
        if (gcsObject == null) {
            return null;
        }
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(options);
        MutableBlobMetadata metadata = this.objectToBlobMetadata.apply(gcsObject);
        BlobImpl blob = new BlobImpl(metadata);
        Payload payload = this.api.getObjectApi().download(container, Strings2.urlEncode(name, new char[0]), httpOptions).getPayload();
        payload.setContentMetadata(metadata.getContentMetadata());
        blob.setPayload(payload);
        return blob;
    }

    @Override
    public void removeBlob(String container, String name) {
        this.api.getObjectApi().deleteObject(container, Strings2.urlEncode(name, new char[0]));
    }

    @Override
    public BlobAccess getBlobAccess(String container, String name) {
        ObjectAccessControls controls = this.api.getObjectAccessControlsApi().getObjectAccessControls(container, Strings2.urlEncode(name, new char[0]), "allUsers");
        if (controls != null && controls.role() == DomainResourceReferences.ObjectRole.READER) {
            return BlobAccess.PUBLIC_READ;
        }
        return BlobAccess.PRIVATE;
    }

    @Override
    public void setBlobAccess(String container, String name, BlobAccess access) {
        if (access == BlobAccess.PUBLIC_READ) {
            ObjectAccessControls controls = ObjectAccessControls.builder().entity("allUsers").bucket(container).role(DomainResourceReferences.ObjectRole.READER).build();
            this.api.getObjectApi().patchObject(container, Strings2.urlEncode(name, new char[0]), new ObjectTemplate().addAcl(controls));
        } else {
            this.api.getObjectAccessControlsApi().deleteObjectAccessControls(container, Strings2.urlEncode(name, new char[0]), "allUsers");
        }
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        ListPageWithPrefixes<GoogleCloudStorageObject> list = this.api.getObjectApi().listObjects(container);
        if (list == null || !list.iterator().hasNext() && list.prefixes().isEmpty()) {
            if (!this.api.getBucketApi().deleteBucket(container)) {
                return true;
            }
            return !this.api.getBucketApi().bucketExist(container);
        }
        return false;
    }

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        if (options.ifMatch() != null) {
            throw new UnsupportedOperationException("GCS does not support ifMatch");
        }
        if (options.ifNoneMatch() != null) {
            throw new UnsupportedOperationException("GCS does not support ifNoneMatch");
        }
        if (options.ifModifiedSince() != null) {
            throw new UnsupportedOperationException("GCS does not support ifModifiedSince");
        }
        if (options.ifUnmodifiedSince() != null) {
            throw new UnsupportedOperationException("GCS does not support ifUnmodifiedSince");
        }
        if (options.contentMetadata() == null && options.userMetadata() == null) {
            return this.api.getObjectApi().copyObject(toContainer, Strings2.urlEncode(toName, new char[0]), fromContainer, Strings2.urlEncode(fromName, new char[0])).etag();
        }
        ObjectTemplate template = new ObjectTemplate();
        if (options.contentMetadata() != null) {
            String contentType;
            String contentLanguage;
            ContentMetadata contentMetadata = options.contentMetadata();
            String contentDisposition = contentMetadata.getContentDisposition();
            if (contentDisposition != null) {
                template.contentDisposition(contentDisposition);
            }
            if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                template.contentLanguage(contentLanguage);
            }
            if ((contentType = contentMetadata.getContentType()) != null) {
                template.contentType(contentType);
            }
        }
        if (options.userMetadata() != null) {
            template.customMetadata(options.userMetadata());
        }
        return this.api.getObjectApi().copyObject(toContainer, Strings2.urlEncode(toName, new char[0]), fromContainer, Strings2.urlEncode(fromName, new char[0]), template).etag();
    }

    @Override
    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        String uploadId = UUID.randomUUID().toString();
        return MultipartUpload.create(container, blobMetadata.getName(), uploadId, blobMetadata, options);
    }

    @Override
    public void abortMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<MultipartPart> parts = this.listMultipartUpload(mpu);
        for (MultipartPart part : parts) {
            builder.add(GoogleCloudStorageBlobStore.getMPUPartName(mpu, part.partNumber()));
        }
        this.removeBlobs(mpu.containerName(), builder.build());
    }

    @Override
    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        ImmutableList.Builder objectsBuilder = ImmutableList.builder();
        for (MultipartPart part : parts) {
            objectsBuilder.add(this.api.getObjectApi().getObject(mpu.containerName(), Strings2.urlEncode(GoogleCloudStorageBlobStore.getMPUPartName(mpu, part.partNumber()), new char[0])));
        }
        ObjectTemplate destination = this.blobMetadataToObjectTemplate.apply(mpu.blobMetadata());
        ImmutableCollection objects = objectsBuilder.build();
        if (!objects.isEmpty()) {
            destination.storageClass(((GoogleCloudStorageObject)objects.get(0)).storageClass());
        }
        if (mpu.putOptions().getBlobAccess() == BlobAccess.PUBLIC_READ) {
            ObjectAccessControls controls = ObjectAccessControls.builder().entity("allUsers").bucket(mpu.containerName()).role(DomainResourceReferences.ObjectRole.READER).build();
            destination.addAcl(controls);
        }
        ComposeObjectTemplate template = ComposeObjectTemplate.builder().fromGoogleCloudStorageObject(objects).destination(destination).build();
        String eTag = this.api.getObjectApi().composeObjects(mpu.containerName(), Strings2.urlEncode(mpu.blobName(), new char[0]), template).etag();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MultipartPart part : parts) {
            builder.add(GoogleCloudStorageBlobStore.getMPUPartName(mpu, part.partNumber()));
        }
        this.removeBlobs(mpu.containerName(), builder.build());
        return eTag;
    }

    @Override
    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        String partName = GoogleCloudStorageBlobStore.getMPUPartName(mpu, partNumber);
        long partSize = payload.getContentMetadata().getContentLength();
        GoogleCloudStorageObject object = this.api.getObjectApi().simpleUpload(mpu.containerName(), "application/unknown", partSize, payload, new InsertObjectOptions().name(partName));
        return MultipartPart.create(partNumber, partSize, object.etag(), object.updated());
    }

    @Override
    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder parts = ImmutableList.builder();
        PageSet<? extends StorageMetadata> pageSet = this.list(mpu.containerName(), new ListContainerOptions().prefix(mpu.id() + "_"));
        for (StorageMetadata storageMetadata : pageSet) {
            int lastUnderscore = storageMetadata.getName().lastIndexOf(95);
            int partNumber = Integer.parseInt(storageMetadata.getName().substring(lastUnderscore + 1));
            parts.add(MultipartPart.create(partNumber, storageMetadata.getSize(), storageMetadata.getETag(), storageMetadata.getLastModified()));
        }
        return parts.build();
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String container) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public long getMinimumMultipartPartSize() {
        return 0x500000L;
    }

    @Override
    public long getMaximumMultipartPartSize() {
        return 0x140000000L;
    }

    @Override
    public int getMaximumNumberOfParts() {
        return 32;
    }

    private static String getMPUPartName(MultipartUpload mpu, int partNumber) {
        return String.format("%s_%08d", mpu.id(), partNumber);
    }
}

