/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.jamesmurty.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.pulsar.jcloud.shade.com.jamesmurty.utils.BaseXMLBuilder;
import org.apache.pulsar.jcloud.shade.com.jamesmurty.utils.XMLBuilderRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLBuilder2
extends BaseXMLBuilder {
    protected XMLBuilder2(Document xmlDocument) {
        super(xmlDocument);
    }

    protected XMLBuilder2(Node myNode, Node parentNode) {
        super(myNode, parentNode);
    }

    private static RuntimeException wrapExceptionAsRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new XMLBuilderRuntimeException(e);
    }

    public static XMLBuilder2 create(String name, String namespaceURI) {
        try {
            return new XMLBuilder2(XMLBuilder2.createDocumentImpl(name, namespaceURI));
        }
        catch (ParserConfigurationException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public static XMLBuilder2 create(String name) {
        return XMLBuilder2.create(name, null);
    }

    public static XMLBuilder2 parse(InputSource inputSource) {
        try {
            return new XMLBuilder2(XMLBuilder2.parseDocumentImpl(inputSource));
        }
        catch (ParserConfigurationException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
        catch (SAXException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
        catch (IOException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public static XMLBuilder2 parse(String xmlString) {
        return XMLBuilder2.parse(new InputSource(new StringReader(xmlString)));
    }

    public static XMLBuilder2 parse(File xmlFile) {
        try {
            return XMLBuilder2.parse(new InputSource(new FileReader(xmlFile)));
        }
        catch (FileNotFoundException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public XMLBuilder2 stripWhitespaceOnlyTextNodes() {
        try {
            super.stripWhitespaceOnlyTextNodesImpl();
            return this;
        }
        catch (XPathExpressionException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public XMLBuilder2 importXMLBuilder(BaseXMLBuilder builder) {
        super.importXMLBuilderImpl(builder);
        return this;
    }

    public XMLBuilder2 root() {
        return new XMLBuilder2(this.getDocument());
    }

    public XMLBuilder2 xpathFind(String xpath, NamespaceContext nsContext) {
        try {
            Node foundNode = super.xpathFindImpl(xpath, nsContext);
            return new XMLBuilder2(foundNode, null);
        }
        catch (XPathExpressionException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public XMLBuilder2 xpathFind(String xpath) {
        return this.xpathFind(xpath, null);
    }

    public XMLBuilder2 element(String name) {
        String namespaceURI = super.lookupNamespaceURIImpl(name);
        return this.element(name, namespaceURI);
    }

    public XMLBuilder2 elem(String name) {
        return this.element(name);
    }

    public XMLBuilder2 e(String name) {
        return this.element(name);
    }

    public XMLBuilder2 element(String name, String namespaceURI) {
        Element elem = super.elementImpl(name, namespaceURI);
        return new XMLBuilder2(elem, this.getElement());
    }

    public XMLBuilder2 elementBefore(String name) {
        Element newElement = super.elementBeforeImpl(name);
        return new XMLBuilder2(newElement, null);
    }

    public XMLBuilder2 elementBefore(String name, String namespaceURI) {
        Element newElement = super.elementBeforeImpl(name, namespaceURI);
        return new XMLBuilder2(newElement, null);
    }

    public XMLBuilder2 attribute(String name, String value) {
        super.attributeImpl(name, value);
        return this;
    }

    public XMLBuilder2 attr(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder2 a(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder2 text(String value, boolean replaceText) {
        super.textImpl(value, replaceText);
        return this;
    }

    public XMLBuilder2 text(String value) {
        return this.text(value, false);
    }

    public XMLBuilder2 t(String value) {
        return this.text(value);
    }

    public XMLBuilder2 cdata(String data) {
        super.cdataImpl(data);
        return this;
    }

    public XMLBuilder2 data(String data) {
        return this.cdata(data);
    }

    public XMLBuilder2 d(String data) {
        return this.cdata(data);
    }

    public XMLBuilder2 cdata(byte[] data) {
        super.cdataImpl(data);
        return this;
    }

    public XMLBuilder2 data(byte[] data) {
        return this.cdata(data);
    }

    public XMLBuilder2 d(byte[] data) {
        return this.cdata(data);
    }

    public XMLBuilder2 comment(String comment) {
        super.commentImpl(comment);
        return this;
    }

    public XMLBuilder2 cmnt(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder2 c(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder2 instruction(String target, String data) {
        super.instructionImpl(target, data);
        return this;
    }

    public XMLBuilder2 inst(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder2 i(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder2 insertInstruction(String target, String data) {
        super.insertInstructionImpl(target, data);
        return this;
    }

    public XMLBuilder2 reference(String name) {
        super.referenceImpl(name);
        return this;
    }

    public XMLBuilder2 ref(String name) {
        return this.reference(name);
    }

    public XMLBuilder2 r(String name) {
        return this.reference(name);
    }

    public XMLBuilder2 namespace(String prefix, String namespaceURI) {
        super.namespaceImpl(prefix, namespaceURI);
        return this;
    }

    public XMLBuilder2 ns(String prefix, String namespaceURI) {
        return this.attribute(prefix, namespaceURI);
    }

    public XMLBuilder2 namespace(String namespaceURI) {
        this.namespace(null, namespaceURI);
        return this;
    }

    public XMLBuilder2 ns(String namespaceURI) {
        return this.namespace(namespaceURI);
    }

    public XMLBuilder2 up(int steps) {
        Node currNode = super.upImpl(steps);
        if (currNode instanceof Document) {
            return new XMLBuilder2((Document)currNode);
        }
        return new XMLBuilder2(currNode, null);
    }

    public XMLBuilder2 up() {
        return this.up(1);
    }

    public XMLBuilder2 document() {
        return new XMLBuilder2(this.getDocument(), null);
    }

    public String asString() {
        try {
            return super.asString();
        }
        catch (TransformerException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public String asString(Properties properties) {
        try {
            return super.asString(properties);
        }
        catch (TransformerException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public String elementAsString() {
        try {
            return super.elementAsString();
        }
        catch (TransformerException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public String elementAsString(Properties outputProperties) {
        try {
            return super.elementAsString(outputProperties);
        }
        catch (TransformerException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public void toWriter(boolean wholeDocument, Writer writer, Properties outputProperties) {
        try {
            super.toWriter(wholeDocument, writer, outputProperties);
        }
        catch (TransformerException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public void toWriter(Writer writer, Properties outputProperties) {
        try {
            super.toWriter(writer, outputProperties);
        }
        catch (TransformerException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public Object xpathQuery(String xpath, QName type, NamespaceContext nsContext) {
        try {
            return super.xpathQuery(xpath, type, nsContext);
        }
        catch (XPathExpressionException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }

    public Object xpathQuery(String xpath, QName type) {
        try {
            return super.xpathQuery(xpath, type);
        }
        catch (XPathExpressionException e) {
            throw XMLBuilder2.wrapExceptionAsRuntimeException(e);
        }
    }
}

