/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Region;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.all.JustProvider;

@Singleton
public class RegionToProvider
implements LocationsSupplier {
    private final JustProvider justProvider;
    private final Supplier<Set<String>> regionsSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;

    @Inject
    public RegionToProvider(JustProvider justProvider, @Region Supplier<Set<String>> regionsSupplier, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier) {
        this.justProvider = Preconditions.checkNotNull(justProvider, "justProvider");
        this.regionsSupplier = Preconditions.checkNotNull(regionsSupplier, "regionsSupplier");
        this.isoCodesByIdSupplier = Preconditions.checkNotNull(isoCodesByIdSupplier, "isoCodesByIdSupplier");
    }

    @Override
    public Set<? extends Location> get() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Location provider = (Location)Iterables.getOnlyElement(this.justProvider.get());
        Set<String> regions = this.regionsSupplier.get();
        Preconditions.checkState(!regions.isEmpty(), "no regions found for provider %s, using supplier %s", provider, this.regionsSupplier);
        Map<String, Supplier<Set<String>>> isoCodesById = this.isoCodesByIdSupplier.get();
        for (String region : regions) {
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.REGION).id(region).description(region).parent(provider);
            if (isoCodesById.containsKey(region)) {
                builder.iso3166Codes((Iterable<String>)isoCodesById.get(region).get());
            }
            locations.add(builder.build());
        }
        return locations.build();
    }
}

