/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteSource;
import org.jclouds.functions.ToLowerCase;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Multimaps2;

public class HttpMessage
extends PayloadEnclosingImpl {
    protected final Multimap<String, String> headers;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHttpMessage(this);
    }

    protected HttpMessage(Multimap<String, String> headers, @Nullable Payload payload) {
        super(payload);
        this.headers = ImmutableMultimap.copyOf(Preconditions.checkNotNull(headers, "headers"));
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public String getFirstHeaderOrNull(String string) {
        Collection<String> values = this.headers.get(string);
        if (values.isEmpty()) {
            Multimap<String, String> lowerCaseHeaders = Multimaps2.transformKeys(this.getHeaders(), new ToLowerCase());
            values = lowerCaseHeaders.get(string.toLowerCase());
        }
        return values.size() >= 1 ? values.iterator().next() : null;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.headers, this.payload);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpMessage)) {
            return false;
        }
        HttpMessage that = (HttpMessage)HttpMessage.class.cast(obj);
        return Objects.equal(this.headers, that.headers) && Objects.equal(this.payload, that.payload);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper("").omitNullValues().add("headers", this.headers).add("payload", this.payload);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected ImmutableMultimap.Builder<String, String> headers = ImmutableMultimap.builder();
        protected Payload payload;

        protected abstract T self();

        public T payload(Payload payload) {
            this.payload = payload;
            return this.self();
        }

        public T payload(byte[] payload) {
            this.payload = Payloads.newByteArrayPayload(Preconditions.checkNotNull(payload, "payload"));
            return this.self();
        }

        public T payload(ByteSource payload) {
            this.payload = Payloads.newByteSourcePayload(Preconditions.checkNotNull(payload, "payload"));
            return this.self();
        }

        public T payload(File payload) {
            this.payload = Payloads.newFilePayload(Preconditions.checkNotNull(payload, "payload"));
            return this.self();
        }

        public T payload(InputStream payload) {
            this.payload = Payloads.newInputStreamPayload(Preconditions.checkNotNull(payload, "payload"));
            return this.self();
        }

        public T payload(String payload) {
            this.payload = Payloads.newStringPayload(Preconditions.checkNotNull(payload, "payload"));
            return this.self();
        }

        public T headers(Multimap<String, String> headers) {
            this.headers = ImmutableMultimap.builder();
            this.headers.putAll(Preconditions.checkNotNull(headers, "headers"));
            return this.self();
        }

        public T replaceHeaders(Multimap<String, String> headers) {
            Preconditions.checkNotNull(headers, "headers");
            ImmutableMultimap<String, String> oldHeaders = this.headers.build();
            this.headers = ImmutableMultimap.builder();
            this.headers.putAll(Multimaps2.replaceEntries(oldHeaders, headers));
            return this.self();
        }

        public T removeHeader(String name) {
            Preconditions.checkNotNull(name, "name");
            ImmutableMultimap<String, String> oldHeaders = this.headers.build();
            this.headers = ImmutableMultimap.builder();
            this.headers.putAll(Multimaps2.withoutKey(oldHeaders, name));
            return this.self();
        }

        public T addHeader(String name, String ... values) {
            this.headers.putAll(Preconditions.checkNotNull(name, "name"), (String[])((Object[])Preconditions.checkNotNull(values, "values of %s", name)));
            return this.self();
        }

        public T replaceHeader(String name, String ... values) {
            Preconditions.checkNotNull(name, "name");
            Preconditions.checkNotNull(values, "values of %s", name);
            return this.replaceHeaders(ImmutableMultimap.builder().putAll(name, values).build());
        }

        public HttpMessage build() {
            return new HttpMessage(this.headers.build(), this.payload);
        }

        public T fromHttpMessage(HttpMessage in) {
            return ((Builder)this.headers(in.getHeaders())).payload(in.getPayload());
        }
    }
}

