/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.MoreExecutors;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.SimpleTimeLimiter;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pulsar.jcloud.shade.com.google.common.util.concurrent.TimeLimiter;
import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.concurrent.DynamicExecutors;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.concurrent.config.WithSubmissionTrace;
import org.jclouds.lifecycle.Closer;
import org.jclouds.logging.Logger;

@ConfiguresExecutorService
public class ExecutorServiceModule
extends AbstractModule {
    private static final Method CREATE_STL;
    private static final Constructor<SimpleTimeLimiter> CONSTRUCT_STL;
    final ListeningExecutorService userExecutorFromConstructor;

    public static SimpleTimeLimiter createSimpleTimeLimiter(ExecutorService executorService) {
        try {
            if (CREATE_STL != null) {
                return (SimpleTimeLimiter)CREATE_STL.invoke(null, executorService);
            }
            if (CONSTRUCT_STL != null) {
                return CONSTRUCT_STL.newInstance(executorService);
            }
            throw new UnsupportedOperationException("Can't find SimpleTimeLimiter creator or constructor taking ExecutorService");
        }
        catch (IllegalAccessException iae) {
            throw new UnsupportedOperationException("Can't access SimpleTimeLimiter method/ctor", iae);
        }
        catch (InstantiationException ie) {
            throw new UnsupportedOperationException("Can't construct SimpleTimeLimiter", ie);
        }
        catch (InvocationTargetException ite) {
            Throwable throwable = ite.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UnsupportedOperationException("Checked exception thrown while creating SimpleTimeLimiter", throwable);
        }
    }

    public ExecutorServiceModule() {
        this.userExecutorFromConstructor = null;
    }

    @Deprecated
    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ExecutorService userExecutor, ExecutorService ioExecutor) {
        this(userExecutor);
    }

    @Deprecated
    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ListeningExecutorService ioExecutor) {
        this(userExecutor);
    }

    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ExecutorService userExecutor) {
        this(MoreExecutors.listeningDecorator(userExecutor));
    }

    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.userExecutorFromConstructor = WithSubmissionTrace.wrap(userExecutor);
    }

    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    final TimeLimiter timeLimiter(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        return ExecutorServiceModule.createSimpleTimeLimiter(userExecutor);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.user-threads")
    final ListeningExecutorService provideListeningUserExecutorService(@Named(value="jclouds.user-threads") int count, Closer closer) {
        if (this.userExecutorFromConstructor != null) {
            return this.userExecutorFromConstructor;
        }
        return ExecutorServiceModule.shutdownOnClose(WithSubmissionTrace.wrap(this.newThreadPoolNamed("user thread %d", count)), closer);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.user-threads")
    final ExecutorService provideUserExecutorService(@Named(value="jclouds.user-threads") ListeningExecutorService in) {
        return in;
    }

    static <T extends ListeningExecutorService> T shutdownOnClose(T service, Closer closer) {
        closer.addToClose(new ShutdownExecutorOnClose(service));
        return service;
    }

    private ListeningExecutorService newCachedThreadPoolNamed(String name) {
        return MoreExecutors.listeningDecorator(Executors.newCachedThreadPool(this.namedThreadFactory(name)));
    }

    private ListeningExecutorService newThreadPoolNamed(String name, int maxCount) {
        return maxCount == 0 ? this.newCachedThreadPoolNamed(name) : this.newScalingThreadPoolNamed(name, maxCount);
    }

    private ListeningExecutorService newScalingThreadPoolNamed(String name, int maxCount) {
        return MoreExecutors.listeningDecorator(DynamicExecutors.newScalingThreadPool(1, maxCount, 60000L, this.namedThreadFactory(name)));
    }

    private ThreadFactory namedThreadFactory(String name) {
        return new ThreadFactoryBuilder().setNameFormat(name).setThreadFactory(Executors.defaultThreadFactory()).build();
    }

    static {
        Method create = null;
        Constructor ctor = null;
        try {
            create = SimpleTimeLimiter.class.getDeclaredMethod("create", ExecutorService.class);
        }
        catch (NoSuchMethodException nsme) {
            try {
                ctor = SimpleTimeLimiter.class.getConstructor(ExecutorService.class);
            }
            catch (NoSuchMethodException nsme2) {
                throw new UnsupportedOperationException("Can't find SimpleTimeLimiter creator or constructor taking ExecutorService", nsme2);
            }
        }
        CREATE_STL = create;
        CONSTRUCT_STL = ctor;
    }

    static final class ShutdownExecutorOnClose
    implements Closeable {
        @Resource
        private Logger logger = Logger.NULL;
        private final ListeningExecutorService service;

        private ShutdownExecutorOnClose(ListeningExecutorService service) {
            this.service = service;
        }

        @Override
        public void close() throws IOException {
            List<Runnable> runnables = this.service.shutdownNow();
            if (!runnables.isEmpty()) {
                this.logger.warn("when shutting down executor %s, runnables outstanding: %s", this.service, runnables);
            }
        }
    }
}

