/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.filters;

import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Charsets;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.Hashing;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.inject.ImplementedBy;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.filters.FormSignerUtils;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.Queries;
import org.jclouds.location.Provider;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.annotations.ApiVersion;

public final class FormSignerV4
implements FormSigner {
    private final String apiVersion;
    private final Supplier<Credentials> creds;
    private final org.apache.pulsar.jcloud.shade.javax.inject.Provider<String> iso8601Timestamp;
    private final ServiceAndRegion serviceAndRegion;

    @Inject
    FormSignerV4(@ApiVersion String apiVersion, @Provider Supplier<Credentials> creds, @TimeStamp org.apache.pulsar.jcloud.shade.javax.inject.Provider<String> iso8601Timestamp, ServiceAndRegion serviceAndRegion) {
        this.apiVersion = apiVersion;
        this.creds = creds;
        this.iso8601Timestamp = iso8601Timestamp;
        this.serviceAndRegion = serviceAndRegion;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials credentials;
        Preconditions.checkArgument(request.getHeaders().containsKey("Host"), "request is not ready to sign; host not present");
        String host = request.getFirstHeaderOrNull("Host");
        String form = request.getPayload().getRawContent().toString();
        Multimap<String, String> decodedParams = Queries.queryParser().apply(form);
        Preconditions.checkArgument(decodedParams.containsKey("Action"), "request is not ready to sign; Action not present %s", form);
        String timestamp = this.iso8601Timestamp.get();
        String datestamp = timestamp.substring(0, 8);
        String service = this.serviceAndRegion.service();
        String region = this.serviceAndRegion.region(host);
        String credentialScope = Joiner.on('/').join(datestamp, region, service, "aws4_request");
        ImmutableMap.Builder<String, String> signedHeadersBuilder = ImmutableMap.builder().put("content-type", request.getPayload().getContentMetadata().getContentType()).put("host", host).put("x-amz-date", timestamp);
        HttpRequest.Builder requestBuilder = (HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Authorization")).replaceHeader("X-Amz-Date", timestamp);
        if (!decodedParams.containsKey("Version")) {
            Optional<String> optAnnotatedVersion = FormSignerUtils.getAnnotatedApiVersion(request);
            if (optAnnotatedVersion.isPresent()) {
                String annotatedVersion = optAnnotatedVersion.get();
                String greater = annotatedVersion.compareTo(this.apiVersion) > 0 ? annotatedVersion : this.apiVersion;
                requestBuilder.addFormParam("Version", greater);
            } else {
                requestBuilder.addFormParam("Version", this.apiVersion);
            }
        }
        if ((credentials = this.creds.get()) instanceof SessionCredentials) {
            String token = ((SessionCredentials)SessionCredentials.class.cast(credentials)).getSessionToken();
            requestBuilder.replaceHeader("X-Amz-Security-Token", token);
            signedHeadersBuilder.put("x-amz-security-token", token);
        }
        ImmutableMap<String, String> signedHeaders = signedHeadersBuilder.build();
        String stringToSign = FormSignerV4.createStringToSign(requestBuilder.build(), signedHeaders, credentialScope);
        byte[] signatureKey = FormSignerV4.signatureKey(credentials.credential, datestamp, region, service);
        String signature = BaseEncoding.base16().lowerCase().encode(FormSignerV4.hmacSHA256(stringToSign, signatureKey));
        StringBuilder authorization = new StringBuilder("AWS4-HMAC-SHA256 ");
        authorization.append("Credential=").append(credentials.identity).append('/').append(credentialScope).append(", ");
        authorization.append("SignedHeaders=").append(Joiner.on(';').join(signedHeaders.keySet())).append(", ");
        authorization.append("Signature=").append(signature);
        return ((HttpRequest.Builder)requestBuilder.addHeader("Authorization", authorization.toString())).build();
    }

    static byte[] signatureKey(String secretKey, String datestamp, String region, String service) {
        byte[] kSecret = ("AWS4" + secretKey).getBytes(Charsets.UTF_8);
        byte[] kDate = FormSignerV4.hmacSHA256(datestamp, kSecret);
        byte[] kRegion = FormSignerV4.hmacSHA256(region, kDate);
        byte[] kService = FormSignerV4.hmacSHA256(service, kRegion);
        byte[] kSigning = FormSignerV4.hmacSHA256("aws4_request", kService);
        return kSigning;
    }

    static byte[] hmacSHA256(String data, byte[] key) {
        try {
            String algorithm = "HmacSHA256";
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data.getBytes(Charsets.UTF_8));
        }
        catch (GeneralSecurityException e) {
            throw new HttpException(e);
        }
    }

    static String createStringToSign(HttpRequest request, Map<String, String> signedHeaders, String credentialScope) {
        StringBuilder canonicalRequest = new StringBuilder();
        canonicalRequest.append(request.getMethod()).append("\n");
        canonicalRequest.append(request.getEndpoint().getPath()).append("\n");
        Preconditions.checkArgument(request.getEndpoint().getQuery() == null, "Query parameters not yet supported %s", request);
        canonicalRequest.append("\n");
        for (Map.Entry<String, String> entry : signedHeaders.entrySet()) {
            canonicalRequest.append(entry.getKey()).append(':').append(entry.getValue()).append('\n');
        }
        canonicalRequest.append("\n");
        canonicalRequest.append(Joiner.on(';').join(signedHeaders.keySet())).append('\n');
        String payload = request.getPayload().getRawContent().toString();
        canonicalRequest.append(BaseEncoding.base16().lowerCase().encode(Hashing.sha256().hashString(payload, Charsets.UTF_8).asBytes()));
        StringBuilder toSign = new StringBuilder();
        toSign.append("AWS4-HMAC-SHA256").append('\n');
        toSign.append(signedHeaders.get("x-amz-date")).append('\n');
        toSign.append(credentialScope).append('\n');
        toSign.append(BaseEncoding.base16().lowerCase().encode(Hashing.sha256().hashString(canonicalRequest.toString(), Charsets.UTF_8).asBytes()));
        return toSign.toString();
    }

    @ImplementedBy(value=AWSServiceAndRegion.class)
    public static interface ServiceAndRegion {
        public String service();

        public String region(String var1);

        public static final class AWSServiceAndRegion
        implements ServiceAndRegion {
            private final String service;

            @Inject
            AWSServiceAndRegion(ProviderMetadata provider) {
                this(provider.getEndpoint());
            }

            AWSServiceAndRegion(String endpoint) {
                this.service = AWSServiceAndRegion.parseServiceAndRegion(URI.create(Preconditions.checkNotNull(endpoint, "endpoint")).getHost()).get(0);
            }

            @Override
            public String service() {
                return this.service;
            }

            @Override
            public String region(String host) {
                return AWSServiceAndRegion.parseServiceAndRegion(host).get(1);
            }

            private static List<String> parseServiceAndRegion(String host) {
                return Splitter.on('.').splitToList(host);
            }
        }
    }
}

