/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.binders;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.HashCode;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.rest.Binder;

public class SetPayload
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Date expires;
        Long contentLength;
        HttpMessage.Builder builder = request.toBuilder();
        Payload payload = (Payload)Payload.class.cast(input);
        if (payload.getContentMetadata().getContentType() == null) {
            payload.getContentMetadata().setContentType("application/octet-stream");
        }
        if ((contentLength = payload.getContentMetadata().getContentLength()) != null && contentLength >= 0L) {
            Preconditions.checkArgument(contentLength <= 0x140000000L, "maximum size for put object is 5GB, %s", contentLength);
        } else {
            ((HttpRequest.Builder)builder.replaceHeader("Transfer-Encoding", "chunked")).build();
        }
        HashCode md5 = payload.getContentMetadata().getContentMD5AsHashCode();
        if (md5 != null) {
            builder.replaceHeader("ETag", BaseEncoding.base16().lowerCase().encode(md5.asBytes()));
        }
        if ((expires = payload.getContentMetadata().getExpires()) != null) {
            ((HttpRequest.Builder)builder.addHeader("X-Delete-At", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(expires.getTime())))).build();
        }
        return (R)((HttpRequest.Builder)builder.payload(payload)).build();
    }
}

