/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Charsets;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.hash.Hashing;
import org.apache.pulsar.jcloud.shade.com.jamesmurty.utils.XMLBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.Binder;

public class BindIterableAsPayloadToDeleteRequest
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String content;
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input is null") instanceof Iterable, "this binder is only valid for an Iterable");
        Preconditions.checkNotNull(request, "request is null");
        Iterable keys = (Iterable)input;
        Preconditions.checkArgument(!Iterables.isEmpty(keys), "The list of keys should not be empty.");
        try {
            XMLBuilder rootBuilder = XMLBuilder.create("Delete");
            for (String key : keys) {
                XMLBuilder ownerBuilder = rootBuilder.elem("Object");
                XMLBuilder xMLBuilder = ownerBuilder.elem("Key").text(key);
            }
            Properties outputProperties = new Properties();
            outputProperties.put("omit-xml-declaration", "yes");
            content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + rootBuilder.asString(outputProperties);
        }
        catch (ParserConfigurationException pce) {
            throw Throwables.propagate(pce);
        }
        catch (TransformerException te) {
            throw Throwables.propagate(te);
        }
        StringPayload payload = Payloads.newStringPayload(content);
        payload.getContentMetadata().setContentType("text/xml");
        byte[] md5 = Hashing.md5().hashString(content, Charsets.UTF_8).asBytes();
        payload.getContentMetadata().setContentMD5(md5);
        request.setPayload(payload);
        return request;
    }
}

