/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sts.domain;

import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;

public final class User {
    private final String id;
    private final String arn;

    public static User fromIdAndArn(String id, String arn) {
        return new User(id, arn);
    }

    private User(String id, String arn) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.arn = Preconditions.checkNotNull(arn, "arn for %s", id);
    }

    public String getId() {
        return this.id;
    }

    public String getArn() {
        return this.arn;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.arn);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return Objects.equal(this.id, other.id) && Objects.equal(this.arn, other.arn);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("arn", this.arn).toString();
    }
}

