/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.config;

import java.io.Closeable;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.inject.Injector;
import org.apache.pulsar.jcloud.shade.com.google.inject.name.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.GET;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.openstack.keystone.auth.config.AuthenticationModule;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.swift.v1.binders.TempAuthBinder;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.config.BinderUtils;

public final class SwiftAuthenticationModule
extends AuthenticationModule {
    @Override
    protected void configure() {
        super.configure();
        BinderUtils.bindHttpApi(this.binder(), TempAuthApi.class);
    }

    @Override
    protected Map<String, Function<Credentials, AuthInfo>> authenticationMethods(Injector i) {
        return ImmutableMap.builder().putAll(super.authenticationMethods(i)).put("tempAuthCredentials", i.getInstance(TempAuth.class)).build();
    }

    static final class AdaptTempAuthResponseToAccess
    implements Function<HttpResponse, Access>,
    InvocationContext<AdaptTempAuthResponseToAccess> {
        private final String identityHeaderNameUser;
        private final String apiVersion;
        private String host;
        private String username;

        @Inject
        AdaptTempAuthResponseToAccess(@ApiVersion String apiVersion, @Named(value="jclouds.swift.tempAuth.headerUser") String identityHeaderNameUser) {
            this.apiVersion = apiVersion;
            this.identityHeaderNameUser = identityHeaderNameUser;
        }

        @Override
        public Access apply(HttpResponse from) {
            HttpUtils.releasePayload(from);
            URI storageUrl = null;
            String authToken = null;
            for (Map.Entry<String, String> entry : from.getHeaders().entries()) {
                String header = entry.getKey();
                if (header.equalsIgnoreCase("X-Storage-Url")) {
                    storageUrl = this.getURI(entry.getValue());
                    continue;
                }
                if (!header.equalsIgnoreCase("X-Auth-Token")) continue;
                authToken = entry.getValue();
            }
            if (storageUrl == null || authToken == null) {
                throw new AuthorizationException("Invalid headers in TempAuth response " + from);
            }
            Date expires = new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(24L));
            return ((Access.Builder)((Access.Builder)((Access.Builder)Access.builder().user(((User.Builder)((User.Builder)User.builder().id(this.username)).name(this.username)).build())).token(((Token.Builder)((Token.Builder)Token.builder().id(authToken)).expires(expires)).build())).service(((Service.Builder)((Service.Builder)((Service.Builder)Service.builder().name("Object Storage")).type("object-store")).endpoint(((Endpoint.Builder)((Endpoint.Builder)((Endpoint.Builder)Endpoint.builder().publicURL(storageUrl)).id(this.apiVersion)).region(storageUrl.getHost())).build())).build())).build();
        }

        private URI getURI(String headerValue) {
            if (headerValue == null) {
                return null;
            }
            URI toReturn = URI.create(headerValue);
            if (!"127.0.0.1".equals(toReturn.getHost())) {
                return toReturn;
            }
            return Uris.uriBuilder(toReturn).host(this.host).build();
        }

        @Override
        public AdaptTempAuthResponseToAccess setContext(HttpRequest request) {
            String host;
            this.host = host = request.getEndpoint().getHost();
            this.username = request.getFirstHeaderOrNull(this.identityHeaderNameUser);
            return this;
        }
    }

    @VirtualHost
    static interface TempAuthApi
    extends Closeable {
        @Named(value="TempAuth")
        @GET
        @Consumes
        @ResponseParser(value=AdaptTempAuthResponseToAccess.class)
        public Access auth(@BinderParam(value=TempAuthBinder.class) Credentials var1);
    }

    static final class TempAuth
    implements Function<Credentials, AuthInfo> {
        private final TempAuthApi delegate;

        @Inject
        TempAuth(TempAuthApi delegate) {
            this.delegate = delegate;
        }

        @Override
        public AuthInfo apply(Credentials input) {
            return this.delegate.auth(input);
        }
    }
}

