/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import java.util.Date;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.internal.CopyObjectResult;
import org.jclouds.util.SaxUtils;

public class CopyObjectHandler
extends ParseSax.HandlerWithResult<ObjectMetadata> {
    private CopyObjectResult metadata;
    private StringBuilder currentText = new StringBuilder();
    @Inject
    private DateService dateParser;
    private Date currentLastModified;
    private String currentETag;

    @Override
    public ObjectMetadata getResult() {
        return this.metadata;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("ETag")) {
            this.currentETag = SaxUtils.currentOrNull(this.currentText);
        } else if (qName.equals("LastModified")) {
            this.currentLastModified = this.dateParser.iso8601DateOrSecondsDateParse(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("CopyObjectResult")) {
            this.metadata = new CopyObjectResult(this.currentLastModified, this.currentETag);
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

