/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.common.collect;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.GwtCompatible;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.GwtIncompatible;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.J2ktIncompatible;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableCollection;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
abstract class ImmutableAsList<E>
extends ImmutableList<E> {
    ImmutableAsList() {
    }

    abstract ImmutableCollection<E> delegateCollection();

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.delegateCollection().contains(target);
    }

    @Override
    public int size() {
        return this.delegateCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegateCollection().isEmpty();
    }

    @Override
    boolean isPartialView() {
        return this.delegateCollection().isPartialView();
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    @GwtIncompatible
    @J2ktIncompatible
    Object writeReplace() {
        return new SerializedForm(this.delegateCollection());
    }

    @GwtIncompatible
    @J2ktIncompatible
    static class SerializedForm
    implements Serializable {
        final ImmutableCollection<?> collection;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableCollection<?> collection) {
            this.collection = collection;
        }

        Object readResolve() {
            return this.collection.asList();
        }
    }
}

