/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import org.apache.pulsar.jcloud.shade.com.google.common.reflect.TypeToken;
import org.apache.pulsar.jcloud.shade.com.google.inject.Singleton;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.filters.Aws4SignerForAuthorizationHeader;
import org.jclouds.s3.filters.Aws4SignerForChunkedUpload;
import org.jclouds.s3.filters.Aws4SignerForQueryString;
import org.jclouds.s3.filters.RequestAuthorizeSignature;

@Singleton
public class RequestAuthorizeSignatureV4
implements RequestAuthorizeSignature {
    private static final String PUT_OBJECT_METHOD = "putObject";
    private static final TypeToken<S3Client> S3_CLIENT_TYPE = new TypeToken<S3Client>(){};
    private final Aws4SignerForAuthorizationHeader signerForAuthorizationHeader;
    private final Aws4SignerForChunkedUpload signerForChunkedUpload;
    private final Aws4SignerForQueryString signerForQueryString;

    @Inject
    public RequestAuthorizeSignatureV4(Aws4SignerForAuthorizationHeader signerForAuthorizationHeader, Aws4SignerForChunkedUpload signerForChunkedUpload, Aws4SignerForQueryString signerForQueryString) {
        this.signerForAuthorizationHeader = signerForAuthorizationHeader;
        this.signerForChunkedUpload = signerForChunkedUpload;
        this.signerForQueryString = signerForQueryString;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        if (this.useChunkedUpload(request)) {
            return this.signForChunkedUpload(request);
        }
        return this.signForAuthorizationHeader(request);
    }

    protected boolean useChunkedUpload(HttpRequest request) {
        if (!GeneratedHttpRequest.class.isAssignableFrom(request.getClass())) {
            return false;
        }
        GeneratedHttpRequest req = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request);
        if (S3_CLIENT_TYPE.equals(req.getInvocation().getInvokable().getOwnerType()) && !PUT_OBJECT_METHOD.equals(req.getInvocation().getInvokable().getName())) {
            return false;
        }
        Payload payload = req.getPayload();
        if (payload == null || payload.getContentMetadata() == null) {
            return false;
        }
        Long contentLength = payload.getContentMetadata().getContentLength();
        if (contentLength == null) {
            return false;
        }
        return contentLength > 0L && !payload.isRepeatable();
    }

    protected HttpRequest signForAuthorizationHeader(HttpRequest request) {
        return this.signerForAuthorizationHeader.sign(request);
    }

    protected HttpRequest signForChunkedUpload(HttpRequest request) {
        return this.signerForChunkedUpload.sign(request);
    }

    @Override
    public HttpRequest signForTemporaryAccess(HttpRequest request, long timeInSeconds) {
        return this.signerForQueryString.sign(request, timeInSeconds);
    }
}

