/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.logging.Logger;
import org.jclouds.util.Throwables2;

public abstract class BaseHttpCommandExecutorService<Q>
implements HttpCommandExecutorService {
    protected final HttpUtils utils;
    protected final ContentMetadataCodec contentMetadataCodec;
    protected final DelegatingRetryHandler retryHandler;
    protected final IOExceptionRetryHandler ioRetryHandler;
    protected final DelegatingErrorHandler errorHandler;
    @Resource
    protected Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.headers")
    protected Logger headerLog = Logger.NULL;
    protected final HttpWire wire;
    private final Set<String> idempotentMethods;

    protected BaseHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, @Named(value="jclouds.idempotent-methods") String idempotentMethods) {
        this.utils = Preconditions.checkNotNull(utils, "utils");
        this.contentMetadataCodec = Preconditions.checkNotNull(contentMetadataCodec, "contentMetadataCodec");
        this.retryHandler = Preconditions.checkNotNull(retryHandler, "retryHandler");
        this.ioRetryHandler = Preconditions.checkNotNull(ioRetryHandler, "ioRetryHandler");
        this.errorHandler = Preconditions.checkNotNull(errorHandler, "errorHandler");
        this.wire = Preconditions.checkNotNull(wire, "wire");
        this.idempotentMethods = ImmutableSet.copyOf(idempotentMethods.split(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse invoke(HttpCommand command) {
        HttpResponse response = null;
        while (true) {
            HttpRequest request = command.getCurrentRequest();
            Q nativeRequest = null;
            try {
                for (HttpRequestFilter filter : request.getFilters()) {
                    request = filter.filter(request);
                }
                HttpUtils.checkRequestHasContentLengthOrChunkedEncoding(request, "After filtering, the request has neither chunked encoding nor content length: " + request);
                this.logger.debug("Sending request %s: %s", request.hashCode(), request.getRequestLine());
                HttpUtils.wirePayloadIfEnabled(this.wire, request);
                this.utils.logRequest(this.headerLog, request, ">>");
                nativeRequest = this.convert(request);
                response = this.invoke(nativeRequest);
                this.logger.debug("Receiving response %s: %s", request.hashCode(), response.getStatusLine());
                this.utils.logResponse(this.headerLog, response, "<<");
                if (response.getPayload() != null && this.wire.enabled()) {
                    this.wire.input(response);
                }
                nativeRequest = null;
                int statusCode = response.getStatusCode();
                if (statusCode < 300 || !this.shouldContinue(command, response)) break;
                continue;
            }
            catch (Exception e) {
                IOException ioe = Throwables2.getFirstThrowableOfType(e, IOException.class);
                if (ioe != null && this.shouldContinue(command, ioe)) continue;
                command.setException(new HttpResponseException(e.getMessage() + " connecting to " + command.getCurrentRequest().getRequestLine(), command, null, (Throwable)e));
            }
            finally {
                this.cleanup(nativeRequest);
                continue;
            }
            break;
        }
        if (command.getException() != null) {
            throw Throwables.propagate(command.getException());
        }
        return response;
    }

    @VisibleForTesting
    boolean shouldContinue(HttpCommand command, HttpResponse response) {
        boolean shouldContinue = false;
        if (this.retryHandler.shouldRetryRequest(command, response)) {
            shouldContinue = true;
        } else {
            this.errorHandler.handleError(command, response);
        }
        HttpUtils.releasePayload(response);
        return shouldContinue;
    }

    boolean shouldContinue(HttpCommand command, IOException response) {
        if (command.getCurrentRequest().getMethod().equals("PUT") && command.getCurrentRequest().getHeaders().containsEntry("Expect", "100-continue") && response instanceof ProtocolException && response.getMessage().equals("Server rejected operation")) {
            this.logger.debug("Caught a protocol exception on a 100-continue PUT request. Attempting to retry.", new Object[0]);
            return this.isIdempotent(command) && this.retryHandler.shouldRetryRequest(command, ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(401)).message("Unauthorized")).build());
        }
        return this.isIdempotent(command) && this.ioRetryHandler.shouldRetryRequest(command, response);
    }

    private boolean isIdempotent(HttpCommand command) {
        String method = command.getCurrentRequest().getMethod();
        if (!this.idempotentMethods.contains(method)) {
            this.logger.error("Command not considered safe to retry because request method is %1$s: %2$s", method, command);
            return false;
        }
        return true;
    }

    protected abstract Q convert(HttpRequest var1) throws IOException, InterruptedException;

    protected abstract HttpResponse invoke(Q var1) throws IOException, InterruptedException;

    protected abstract void cleanup(Q var1);
}

